/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames.games;

import me.RareHyperIon.ChatGames.ChatGames;
import me.RareHyperIon.ChatGames.games.Game;
import me.RareHyperIon.ChatGames.games.GameConfig;
import me.RareHyperIon.ChatGames.games.types.MathGame;
import me.RareHyperIon.ChatGames.games.types.MultipleChoiceGame;
import me.RareHyperIon.ChatGames.games.types.ReactionGame;
import me.RareHyperIon.ChatGames.games.types.TriviaGame;
import me.RareHyperIon.ChatGames.games.types.UnscrambleGame;
import me.RareHyperIon.ChatGames.handlers.LanguageHandler;
import org.bukkit.entity.Player;

public class ActiveGame {
    private final Game game;

    public ActiveGame(ChatGames plugin, GameConfig config, LanguageHandler language) {
        this.game = this.createGame(plugin, config, language);
        this.game.onStart();
    }

    private Game createGame(ChatGames plugin, GameConfig config, LanguageHandler language) {
        return switch (config.name.toLowerCase()) {
            case "reaction" -> new ReactionGame(plugin, config, language);
            case "trivia" -> new TriviaGame(plugin, config, language);
            case "math", "math wizard" -> new MathGame(plugin, config, language);
            case "unscramble" -> new UnscrambleGame(plugin, config, language);
            case "multiple choice" -> new MultipleChoiceGame(plugin, config, language);
            default -> throw new IllegalArgumentException("Unknown game type: " + config.name);
        };
    }

    public void win(Player player) {
        this.game.onWin(player);
    }

    public void end() {
        this.game.onEnd();
    }

    public Game getGame() {
        return this.game;
    }
}

