/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames.games;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;

public class GameConfig {
    public final String name;
    public final String descriptor;
    public final String question;
    public final List<String> answers;
    public final String correctAnswer;
    public final List<Map.Entry<String, String>> choices;
    public final List<String> words;
    public final List<String> commands;
    public final List<ReactionVariant> reactionVariants;
    public final int timeout;

    public GameConfig(FileConfiguration configuration) {
        this.name = configuration.getString("name");
        this.descriptor = configuration.getString("descriptor");
        this.question = configuration.getString("question");
        this.answers = configuration.getStringList("answers");
        this.correctAnswer = configuration.getString("correct-answer");
        this.commands = configuration.getStringList("reward-commands");
        this.timeout = configuration.getInt("timeout");
        this.choices = this.parseChoices(configuration.getList("questions"));
        this.words = configuration.getStringList("words");
        this.reactionVariants = this.parseReactionVariants(configuration.getList("variants"));
    }

    private List<Map.Entry<String, String>> parseChoices(List<?> list) {
        ArrayList<Map.Entry<String, String>> choices = new ArrayList<Map.Entry<String, String>>();
        if (list == null) {
            return choices;
        }
        for (Object object : list) {
            List choice;
            if (!(object instanceof List) || (choice = (List)object).size() < 2) continue;
            choices.add(new AbstractMap.SimpleEntry<String, String>((String)choice.get(0), (String)choice.get(1)));
        }
        return choices;
    }

    private List<ReactionVariant> parseReactionVariants(List<?> list) {
        ArrayList<ReactionVariant> variants = new ArrayList<ReactionVariant>();
        if (list == null) {
            return variants;
        }
        for (Object object : list) {
            if (!(object instanceof Map)) continue;
            Map variantMap = (Map)object;
            String variantName = (String)variantMap.get("name");
            String challenge = (String)variantMap.get("challenge");
            String answer = (String)variantMap.get("answer");
            if (variantName == null || challenge == null || answer == null) continue;
            variants.add(new ReactionVariant(variantName, challenge, answer));
        }
        return variants;
    }

    public static class ReactionVariant {
        public final String name;
        public final String challenge;
        public final String answer;

        public ReactionVariant(String name, String challenge, String answer) {
            this.name = name;
            this.challenge = challenge;
            this.answer = answer;
        }
    }
}

