/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames.handlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import me.RareHyperIon.ChatGames.ChatGames;
import me.RareHyperIon.ChatGames.games.ActiveGame;
import me.RareHyperIon.ChatGames.games.GameConfig;
import me.RareHyperIon.ChatGames.handlers.LanguageHandler;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class GameHandler {
    private final ChatGames plugin;
    private final LanguageHandler language;
    private final List<GameConfig> games = new ArrayList<GameConfig>();
    private int minimumPlayers;
    private BukkitTask intervalTask;
    private boolean automaticGames;
    private ActiveGame game;
    private BukkitTask gameTask;

    public GameHandler(ChatGames plugin, LanguageHandler language) {
        this.plugin = plugin;
        this.language = language;
    }

    public final void interval() {
        if (!this.automaticGames) {
            return;
        }
        if (Bukkit.getOnlinePlayers().size() < this.minimumPlayers) {
            return;
        }
        if (this.game != null) {
            return;
        }
        GameConfig config = this.games.get(ThreadLocalRandom.current().nextInt(this.games.size()));
        this.startGame(config);
    }

    public final void win(Player player) {
        if (this.gameTask != null) {
            this.gameTask.cancel();
            this.gameTask = null;
        }
        if (this.game != null) {
            this.game.win(player);
            this.game = null;
        }
    }

    public final void attemptWin(Player player, String answer) {
        if (this.game == null) {
            return;
        }
        Map.Entry<String, String> questionAnswer = this.game.getGame().getQuestion();
        if (questionAnswer == null || questionAnswer.getValue() == null) {
            this.win(player);
            return;
        }
        String correctAnswer = questionAnswer.getValue();
        if (answer.equalsIgnoreCase(correctAnswer)) {
            this.win(player);
        }
    }

    public final ActiveGame getGame() {
        return this.game;
    }

    public final List<GameConfig> getGames() {
        return this.games;
    }

    public final void load() {
        File[] games;
        File folder = new File(this.plugin.getDataFolder(), "games");
        if (!folder.exists()) {
            this.saveDefault();
        }
        if ((games = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"))) == null || games.length == 0) {
            this.plugin.getSLF4JLogger().warn("There are no games to load.");
            return;
        }
        for (File file : games) {
            if (!file.isFile() || !file.getName().toLowerCase().endsWith(".yml")) continue;
            GameConfig config = new GameConfig((FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
            this.games.add(config);
        }
        FileConfiguration pluginConfig = this.plugin.getConfig();
        int interval = pluginConfig.getInt("GameInterval");
        this.minimumPlayers = pluginConfig.getInt("MinimumPlayers");
        this.automaticGames = pluginConfig.getBoolean("AutomaticGames");
        this.intervalTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, this::interval, 0L, (long)interval * 20L);
        this.plugin.getSLF4JLogger().info("Loaded {} game(s).", (Object)this.games.size());
    }

    private void saveDefault() {
        File folder = new File(this.plugin.getDataFolder(), "games");
        if (!folder.mkdirs()) {
            throw new IllegalStateException("Failed to create games folder.");
        }
        for (String game : List.of("trivia.yml", "math.yml", "unscramble.yml", "reaction.yml", "multiple_choice.yml")) {
            File out = new File(folder, game);
            try {
                InputStream stream = this.plugin.getResource("games/" + game);
                try {
                    if (stream == null) {
                        throw new IllegalStateException("Resource not found in jar.");
                    }
                    Files.copy(stream, out.toPath(), new CopyOption[0]);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create default games file: " + game, e);
            }
        }
        this.plugin.getSLF4JLogger().info("Created default game configurations.");
    }

    public final void reload() {
        this.shutdown();
        this.games.clear();
        this.load();
    }

    public final void shutdown() {
        if (this.intervalTask != null) {
            this.intervalTask.cancel();
            this.intervalTask = null;
        }
        if (this.gameTask != null) {
            this.gameTask.cancel();
            this.gameTask = null;
        }
        if (this.game != null) {
            this.game = null;
        }
    }

    public void startGame(GameConfig config) {
        if (this.game != null) {
            return;
        }
        this.game = new ActiveGame(this.plugin, config, this.language);
        this.gameTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.game != null) {
                this.game.end();
                this.game = null;
            }
            this.gameTask = null;
        }, (long)config.timeout * 20L);
    }

    public void stopGame() {
        if (this.gameTask != null) {
            this.gameTask.cancel();
            this.gameTask = null;
        }
        if (this.game != null) {
            this.game.end();
            this.game = null;
        }
    }

    public void setAutomaticGames(boolean automaticGames) {
        this.automaticGames = automaticGames;
    }
}

