/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames.handlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.RareHyperIon.ChatGames.ChatGames;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageHandler {
    private final ChatGames plugin;
    private final Map<String, String> translations = new HashMap<String, String>();

    public LanguageHandler(ChatGames plugin) {
        this.plugin = plugin;
    }

    public final void load() {
        File file;
        this.translations.clear();
        String language = this.plugin.getConfig().getString("Language", "EN-US");
        if (!new File(this.plugin.getDataFolder(), "language").exists()) {
            this.saveDefault();
        }
        if (!(file = new File(this.plugin.getDataFolder(), "language/" + language + ".yml")).exists()) {
            throw new IllegalStateException("The language \"" + language + "\" doesn't have any translations.");
        }
        YamlConfiguration lang = YamlConfiguration.loadConfiguration((File)file);
        for (String key : lang.getKeys(false)) {
            this.translations.put(key, lang.getString(key));
        }
        this.plugin.getSLF4JLogger().info("Loaded language: {}", (Object)language);
    }

    public final String get(String key) {
        return this.translations.get(key);
    }

    private void saveDefault() {
        File folder = new File(this.plugin.getDataFolder(), "language");
        if (!folder.mkdirs()) {
            throw new IllegalStateException("Failed to create language folder.");
        }
        for (String language : List.of("EN-US.yml")) {
            File out = new File(folder, language);
            try {
                InputStream stream = this.plugin.getResource("language/" + language);
                try {
                    if (stream == null) {
                        throw new IllegalStateException("Resource not found in jar.");
                    }
                    Files.copy(stream, out.toPath(), new CopyOption[0]);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create default language file: " + language, e);
            }
        }
        this.plugin.getSLF4JLogger().info("Created default language configurations.");
    }
}

