/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames.commands;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.RareHyperIon.ChatGames.ChatGames;
import me.RareHyperIon.ChatGames.commands.SubCommand;
import me.RareHyperIon.ChatGames.games.GameConfig;
import me.RareHyperIon.ChatGames.handlers.GameHandler;
import me.RareHyperIon.ChatGames.utility.Utility;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatGameCommand
implements CommandExecutor,
TabCompleter {
    private final ChatGames plugin;

    public ChatGameCommand(ChatGames plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        Player player;
        String prefix = this.plugin.getLanguageHandler().get("Prefix");
        Player player2 = player = sender instanceof Player ? (Player)sender : null;
        if (args.length == 0) {
            sender.sendMessage(Utility.colorComponent(prefix + " &cUsage: /cg <subcommand>", player));
            return true;
        }
        SubCommand subCommand = SubCommand.fromString(args[0]);
        if (subCommand == null) {
            sender.sendMessage(Utility.colorComponent(prefix + " &cUnknown subcommand. Usage: /cg <subcommand>", player));
            return true;
        }
        if (!subCommand.hasPermission(sender)) {
            sender.sendMessage(Utility.colorComponent(prefix + " &cYou don't have permission to use this command.", player));
            return true;
        }
        GameHandler gameHandler = this.plugin.getGameHandler();
        switch (subCommand) {
            case RELOAD: {
                this.plugin.reload();
                sender.sendMessage(Utility.colorComponent(prefix + " &aSuccessfully reloaded ChatGames.", player));
                break;
            }
            case START: {
                if (args.length < 2) {
                    sender.sendMessage(Utility.colorComponent(prefix + " &cUsage: /cg start <game>", player));
                    return true;
                }
                String gameName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
                GameConfig gameConfig = gameHandler.getGames().stream().filter(game -> game.name.equalsIgnoreCase(gameName)).findFirst().orElse(null);
                if (gameConfig == null) {
                    sender.sendMessage(Utility.colorComponent(prefix + " &cUnknown game: " + gameName, player));
                    return true;
                }
                gameHandler.startGame(gameConfig);
                break;
            }
            case STOP: {
                gameHandler.stopGame();
                sender.sendMessage(Utility.colorComponent(prefix + " &aGame stopped.", player));
                break;
            }
            case LIST: {
                sender.sendMessage(Utility.colorComponent(prefix + " &b&lAvailable games:", player));
                for (GameConfig game2 : gameHandler.getGames()) {
                    sender.sendMessage(Utility.colorComponent("&e- &a" + game2.displayName, player));
                }
                break;
            }
            case INFO: {
                sender.sendMessage(Utility.colorComponent(prefix + " &aChatGames v" + this.plugin.getDescription().getVersion(), player));
                break;
            }
            case TOGGLE: {
                boolean automaticGames = !this.plugin.getConfig().getBoolean("AutomaticGames");
                this.plugin.getConfig().set("AutomaticGames", (Object)automaticGames);
                this.plugin.saveConfig();
                gameHandler.setAutomaticGames(automaticGames);
                sender.sendMessage(Utility.colorComponent(prefix + " &aAutomatic games have been " + (automaticGames ? "enabled" : "disabled") + ".", player));
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String label, @NotNull String[] args) {
        if (args.length == 1) {
            return Stream.of(SubCommand.values()).filter(subCmd -> subCmd.hasPermission(sender)).map(SubCommand::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).toList();
        }
        if (args.length > 1 && args[0].equalsIgnoreCase("start")) {
            String partialGameName = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)).toLowerCase();
            return this.plugin.getGameHandler().getGames().stream().map(game -> game.name).filter(name -> name.toLowerCase().startsWith(partialGameName)).toList();
        }
        return List.of();
    }
}

