/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames.games;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class GameConfig {
    public final String name;
    public final String descriptor;
    public final String displayName;
    public final List<String> commands;
    public final int timeout;
    public final List<MultipleChoiceQuestion> multipleChoiceQuestions;
    public final List<Map.Entry<String, String>> choices;
    public final List<String> words;
    public final List<ReactionVariant> reactionVariants;

    public GameConfig(FileConfiguration configuration) {
        this.name = configuration.getString("name");
        this.descriptor = configuration.getString("descriptor");
        this.displayName = configuration.getString("display-name", this.name);
        this.commands = configuration.getStringList("reward-commands");
        this.timeout = configuration.getInt("timeout");
        this.multipleChoiceQuestions = this.parseMultipleChoiceQuestions(configuration.getConfigurationSection("questions"));
        this.choices = this.parseChoices(configuration.getList("questions"));
        this.words = configuration.getStringList("words");
        this.reactionVariants = this.parseReactionVariants(configuration.getList("variants"));
    }

    private List<MultipleChoiceQuestion> parseMultipleChoiceQuestions(ConfigurationSection section) {
        ArrayList<MultipleChoiceQuestion> questions = new ArrayList<MultipleChoiceQuestion>();
        if (section == null) {
            return questions;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection questionSection = section.getConfigurationSection(key);
            if (questionSection == null) continue;
            String question = questionSection.getString("question");
            List answers = questionSection.getStringList("answers");
            String correctAnswer = questionSection.getString("correct-answer");
            if (question == null || answers.isEmpty() || correctAnswer == null) continue;
            questions.add(new MultipleChoiceQuestion(question, answers, correctAnswer));
        }
        return questions;
    }

    private List<Map.Entry<String, String>> parseChoices(List<?> list) {
        ArrayList<Map.Entry<String, String>> choices = new ArrayList<Map.Entry<String, String>>();
        if (list == null) {
            return choices;
        }
        for (Object object : list) {
            List choice;
            if (!(object instanceof List) || (choice = (List)object).size() < 2) continue;
            choices.add(new AbstractMap.SimpleEntry<String, String>((String)choice.get(0), (String)choice.get(1)));
        }
        return choices;
    }

    private List<ReactionVariant> parseReactionVariants(List<?> list) {
        ArrayList<ReactionVariant> variants = new ArrayList<ReactionVariant>();
        if (list == null) {
            return variants;
        }
        for (Object object : list) {
            if (!(object instanceof Map)) continue;
            Map variantMap = (Map)object;
            String variantName = (String)variantMap.get("name");
            String challenge = (String)variantMap.get("challenge");
            String answer = (String)variantMap.get("answer");
            if (variantName == null || challenge == null || answer == null) continue;
            variants.add(new ReactionVariant(variantName, challenge, answer));
        }
        return variants;
    }

    public static class MultipleChoiceQuestion {
        public final String question;
        public final List<String> answers;
        public final String correctAnswer;

        public MultipleChoiceQuestion(String question, List<String> answers, String correctAnswer) {
            this.question = question;
            this.answers = answers;
            this.correctAnswer = correctAnswer;
        }
    }

    public static class ReactionVariant {
        public final String name;
        public final String challenge;
        public final String answer;

        public ReactionVariant(String name, String challenge, String answer) {
            this.name = name;
            this.challenge = challenge;
            this.answer = answer;
        }
    }
}

