/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames.games.types;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import me.RareHyperIon.ChatGames.ChatGames;
import me.RareHyperIon.ChatGames.games.Game;
import me.RareHyperIon.ChatGames.games.GameConfig;
import me.RareHyperIon.ChatGames.handlers.LanguageHandler;
import me.RareHyperIon.ChatGames.utility.Utility;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MathGame
extends Game {
    public final Map.Entry<String, String> question;

    public MathGame(ChatGames plugin, GameConfig config, LanguageHandler language) {
        super(plugin, config, language);
        this.question = config.choices.get(ThreadLocalRandom.current().nextInt(config.choices.size()));
    }

    @Override
    public void onStart() {
        if (this.plugin.logFull()) {
            this.plugin.getSLF4JLogger().info("Game \"{}\" has started.", (Object)this.config.name);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            String message = this.language.get("GameStart").replaceAll("\\{prefix}", this.language.get("Prefix")).replaceAll("\\{player}", player.getName()).replaceAll("\\{name}", this.config.displayName).replaceAll("\\{timeout}", String.valueOf(this.config.timeout)).replaceAll("\\{descriptor}", this.config.descriptor).replaceAll("\\{question}", this.question.getKey()).replaceAll("\\n", "\n");
            player.sendMessage(Utility.colorComponent(message, player));
        }
    }

    @Override
    public void onWin(Player player) {
        if (this.plugin.logFull()) {
            this.plugin.getSLF4JLogger().info("Player \"{}\" has won \"{}\"", (Object)player.getName(), (Object)this.config.name);
        }
        for (Player online : Bukkit.getOnlinePlayers()) {
            String message = this.language.get("GameWin").replaceAll("\\{prefix}", this.language.get("Prefix")).replaceAll("\\{player}", player.getName()).replaceAll("\\{name}", this.config.displayName).replaceAll("\\{descriptor}", this.config.descriptor).replaceAll("\\{question}", this.question.getKey()).replaceAll("\\{answer}", this.question.getValue()).replaceAll("\\n", "\n");
            online.sendMessage(Utility.colorComponent(message, online));
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            for (String command : this.config.commands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replaceAll("\\{player}", player.getName()).replaceAll("%player%", player.getName()));
            }
        });
    }

    @Override
    public void onEnd() {
        if (this.plugin.logFull()) {
            this.plugin.getSLF4JLogger().info("Game \"{}\" has ended.", (Object)this.config.name);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            String message = this.language.get("GameEnd").replaceAll("\\{prefix}", this.language.get("Prefix")).replaceAll("\\{player}", player.getName()).replaceAll("\\{name}", this.config.displayName).replaceAll("\\{timeout}", String.valueOf(this.config.timeout)).replaceAll("\\{descriptor}", this.config.descriptor).replaceAll("\\{question}", this.question.getKey()).replaceAll("\\{answer}", this.question.getValue()).replaceAll("\\n", "\n");
            player.sendMessage(Utility.colorComponent(message, player));
        }
    }

    @Override
    public Map.Entry<String, String> getQuestion() {
        return this.question;
    }
}

