/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames.games.types;

import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import me.RareHyperIon.ChatGames.ChatGames;
import me.RareHyperIon.ChatGames.games.Game;
import me.RareHyperIon.ChatGames.games.GameConfig;
import me.RareHyperIon.ChatGames.handlers.LanguageHandler;
import me.RareHyperIon.ChatGames.utility.Utility;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ReactionGame
extends Game {
    private final String word;
    private final GameConfig.ReactionVariant variant;
    private final boolean useVariants;

    public ReactionGame(ChatGames plugin, GameConfig config, LanguageHandler language) {
        super(plugin, config, language);
        if (config.reactionVariants != null && !config.reactionVariants.isEmpty()) {
            this.useVariants = true;
            this.variant = config.reactionVariants.get(ThreadLocalRandom.current().nextInt(config.reactionVariants.size()));
            this.word = null;
        } else {
            this.useVariants = false;
            this.variant = null;
            this.word = config.words.get(ThreadLocalRandom.current().nextInt(config.words.size()));
        }
    }

    @Override
    public void onStart() {
        TextComponent messageComponent;
        String answer;
        String challengeText;
        if (this.plugin.logFull()) {
            this.plugin.getSLF4JLogger().info("Game \"{}\" has started.", (Object)this.config.name);
        }
        if (this.useVariants) {
            challengeText = this.variant.challenge;
            answer = this.variant.answer;
        } else {
            challengeText = this.word;
            answer = null;
        }
        if (answer != null && challengeText.contains("[")) {
            messageComponent = this.parseClickableButtons(challengeText, answer);
        } else {
            messageComponent = new TextComponent(Utility.color(challengeText));
            messageComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/chatgames-internal-win"));
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            String message = this.language.get("ReactionStart").replaceAll("\\{prefix}", this.language.get("Prefix")).replaceAll("\\{player}", player.getName()).replaceAll("\\{name}", this.config.displayName).replaceAll("\\{timeout}", String.valueOf(this.config.timeout)).replaceAll("\\{descriptor}", this.config.descriptor).replaceAll("\\n", "\n");
            if (this.useVariants) {
                message = message.replaceAll("\\{variant}", this.variant.name);
            }
            TextComponent finalMessage = new TextComponent(Utility.color(message));
            finalMessage.addExtra((BaseComponent)messageComponent);
            player.spigot().sendMessage((BaseComponent)finalMessage);
        }
    }

    @Override
    public void onWin(Player player) {
        if (this.plugin.logFull()) {
            this.plugin.getSLF4JLogger().info("Player \"{}\" has won \"{}\"", (Object)player.getName(), (Object)this.config.name);
        }
        for (Player online : Bukkit.getOnlinePlayers()) {
            String message = this.language.get("ReactionWin").replaceAll("\\{prefix}", this.language.get("Prefix")).replaceAll("\\{player}", player.getName()).replaceAll("\\{name}", this.config.displayName).replaceAll("\\{descriptor}", this.config.descriptor).replaceAll("\\n", "\n");
            online.sendMessage(Utility.colorComponent(message, online));
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            for (String command : this.config.commands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replaceAll("\\{player}", player.getName()).replaceAll("%player%", player.getName()));
            }
        });
    }

    @Override
    public void onEnd() {
        if (this.plugin.logFull()) {
            this.plugin.getSLF4JLogger().info("Game \"{}\" has ended.", (Object)this.config.name);
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            String message = this.language.get("ReactionEnd").replaceAll("\\{prefix}", this.language.get("Prefix")).replaceAll("\\{player}", player.getName()).replaceAll("\\{name}", this.config.displayName).replaceAll("\\{timeout}", String.valueOf(this.config.timeout)).replaceAll("\\{descriptor}", this.config.descriptor).replaceAll("\\n", "\n");
            player.sendMessage(Utility.colorComponent(message, player));
        }
    }

    @Override
    public Map.Entry<String, String> getQuestion() {
        if (this.useVariants && this.variant.answer != null) {
            return Map.entry("", this.variant.answer);
        }
        return null;
    }

    private TextComponent parseClickableButtons(String text, String correctAnswer) {
        TextComponent result = new TextComponent();
        StringBuilder currentText = new StringBuilder();
        boolean insideBracket = false;
        StringBuilder buttonText = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '[') {
                StringBuilder colorCodes = new StringBuilder();
                for (int j = currentText.length() - 1; j >= 0; j -= 2) {
                    char prevChar = currentText.charAt(j);
                    if (j <= 0 || currentText.charAt(j - 1) != '&' || !Character.isLetterOrDigit(prevChar) && prevChar != 'r') break;
                    colorCodes.insert(0, currentText.charAt(j - 1));
                    colorCodes.insert(1, prevChar);
                }
                if (colorCodes.length() > 0) {
                    currentText.setLength(currentText.length() - colorCodes.length());
                }
                if (currentText.length() > 0) {
                    result.addExtra((BaseComponent)new TextComponent(Utility.color(currentText.toString())));
                    currentText.setLength(0);
                }
                insideBracket = true;
                buttonText.setLength(0);
                buttonText.append((CharSequence)colorCodes);
                buttonText.append(c);
                continue;
            }
            if (c == ']' && insideBracket) {
                buttonText.append(c);
                insideBracket = false;
                String fullButtonWithColor = buttonText.toString();
                TextComponent buttonComponent = new TextComponent(Utility.color(fullButtonWithColor));
                String buttonTextOnly = fullButtonWithColor.substring(fullButtonWithColor.indexOf(91));
                buttonComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/chatgames-internal-win " + buttonTextOnly));
                result.addExtra((BaseComponent)buttonComponent);
                continue;
            }
            if (insideBracket) {
                buttonText.append(c);
                continue;
            }
            currentText.append(c);
        }
        if (currentText.length() > 0) {
            result.addExtra((BaseComponent)new TextComponent(Utility.color(currentText.toString())));
        }
        return result;
    }
}

