/*
 * Decompiled with CFR 0.152.
 */
package me.RareHyperIon.ChatGames.utility;

import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class Utility {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final boolean PLACEHOLDER_API_ENABLED = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([0-9a-fA-F]{6})");

    public static Component colorComponent(String string, Player player) {
        String processed = string;
        if (PLACEHOLDER_API_ENABLED && player != null) {
            processed = PlaceholderAPI.setPlaceholders((Player)player, (String)processed);
        }
        processed = Utility.translateLegacyToMiniMessage(processed);
        return MINI_MESSAGE.deserialize((Object)processed);
    }

    private static String translateLegacyToMiniMessage(String legacyString) {
        legacyString = HEX_PATTERN.matcher(legacyString).replaceAll("<#$1>");
        return legacyString.replace("&0", "<black>").replace("&1", "<dark_blue>").replace("&2", "<dark_green>").replace("&3", "<dark_aqua>").replace("&4", "<dark_red>").replace("&5", "<dark_purple>").replace("&6", "<gold>").replace("&7", "<gray>").replace("&8", "<dark_gray>").replace("&9", "<blue>").replace("&a", "<green>").replace("&b", "<aqua>").replace("&c", "<red>").replace("&d", "<light_purple>").replace("&e", "<yellow>").replace("&f", "<white>").replace("&k", "<obfuscated>").replace("&l", "<bold>").replace("&m", "<strikethrough>").replace("&n", "<underlined>").replace("&o", "<italic>").replace("&r", "<reset>");
    }

    public static String color(String string) {
        String miniMessageString = Utility.translateLegacyToMiniMessage(string);
        return LegacyComponentSerializer.legacySection().serialize(MINI_MESSAGE.deserialize((Object)miniMessageString));
    }

    public static String stripColor(String string) {
        String miniMessageString = Utility.translateLegacyToMiniMessage(string);
        return PlainTextComponentSerializer.plainText().serialize(MINI_MESSAGE.deserialize((Object)miniMessageString));
    }

    public static String format(String string, Object ... objects) {
        StringBuilder formattedMessage = new StringBuilder(string);
        int placeholderIndex = formattedMessage.indexOf("{}");
        for (int objIndex = 0; placeholderIndex != -1 && objIndex < objects.length; ++objIndex) {
            formattedMessage.replace(placeholderIndex, placeholderIndex + 2, objects[objIndex].toString());
            placeholderIndex = formattedMessage.indexOf("{}", placeholderIndex + 2);
        }
        return "&8[&6ChatGames&8] &r" + String.valueOf(formattedMessage);
    }
}

