/*
 * Decompiled with CFR 0.152.
 */
package io.github.nyankoro328.battle_linker;

import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SpectatorManager {
    public static final SpectatorManager INSTANCE = new SpectatorManager();
    private final Map<UUID, UUID> spectators = new HashMap<UUID, UUID>();

    private SpectatorManager() {
    }

    public void addSpectator(class_1657 spectator, class_1657 target) {
        this.spectators.put(spectator.method_5667(), target.method_5667());
        spectator.method_7353((class_2561)class_2561.method_43470((String)(target.method_5477().getString() + " \u306e\u89b3\u6226\u3092\u958b\u59cb\u3057\u307e\u3059\u3002")).method_27692(class_124.field_1060), false);
    }

    public void removeSpectator(class_1657 spectator) {
        if (this.spectators.remove(spectator.method_5667()) != null) {
            spectator.method_7353((class_2561)class_2561.method_43470((String)"\u89b3\u6226\u3092\u505c\u6b62\u3057\u307e\u3057\u305f\u3002").method_27692(class_124.field_1054), false);
        } else {
            spectator.method_7353((class_2561)class_2561.method_43470((String)"\u3042\u306a\u305f\u306f\u73fe\u5728\u8ab0\u3082\u89b3\u6226\u3057\u3066\u3044\u307e\u305b\u3093\u3002").method_27692(class_124.field_1061), false);
        }
    }

    public void sendBattleChatMessage(PokemonBattle battle, class_2561 message) {
        List battlingPlayers = battle.getPlayers();
        if (battlingPlayers.isEmpty()) {
            return;
        }
        MinecraftServer server = ((class_3222)battlingPlayers.get(0)).method_5682();
        if (server == null) {
            return;
        }
        block0: for (Map.Entry<UUID, UUID> entry : this.spectators.entrySet()) {
            UUID spectatorUuid = entry.getKey();
            UUID targetUuid = entry.getValue();
            for (class_3222 battlingPlayer : battlingPlayers) {
                if (!battlingPlayer.method_5667().equals(targetUuid)) continue;
                class_3222 spectatorPlayer = server.method_3760().method_14602(spectatorUuid);
                if (spectatorPlayer == null) continue block0;
                spectatorPlayer.method_7353(message, false);
                continue block0;
            }
        }
    }

    public void onBattleTick() {
        if (this.spectators.isEmpty()) {
            return;
        }
        this.spectators.forEach((spectatorUuid, targetPlayerUuid) -> {
            class_3222 spectatorPlayer;
            PokemonBattle targetBattle = BattleRegistry.INSTANCE.getBattleByParticipatingPlayerId(targetPlayerUuid);
            if (targetBattle != null && (spectatorPlayer = ((class_3222)targetBattle.getPlayers().get(0)).method_5682().method_3760().method_14602(spectatorUuid)) != null) {
                class_2561 hpMessage = this.createActionBarHpMessage(targetBattle);
                spectatorPlayer.method_7353(hpMessage, true);
            }
        });
    }

    private class_2561 createActionBarHpMessage(PokemonBattle battle) {
        ArrayList pokemonHpTexts = new ArrayList();
        battle.getActors().forEach(actor -> {
            List activePokemonList = actor.getActivePokemon();
            for (ActiveBattlePokemon activePokemon : activePokemonList) {
                BattlePokemon battlePokemon = activePokemon.getBattlePokemon();
                if (battlePokemon == null) continue;
                int currentHp = battlePokemon.getHealth();
                int maxHp = battlePokemon.getMaxHealth();
                double percentage = maxHp > 0 ? (double)currentHp / (double)maxHp * 100.0 : 0.0;
                class_124 color = class_124.field_1068;
                color = percentage <= 25.0 ? class_124.field_1061 : (percentage <= 50.0 ? class_124.field_1054 : class_124.field_1060);
                pokemonHpTexts.add(battlePokemon.getName().method_27661().method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)(currentHp + "/" + maxHp)).method_27692(color)).method_10852((class_2561)class_2561.method_43470((String)(" (" + String.format("%.0f", percentage) + "%)")).method_27692(class_124.field_1080)));
            }
        });
        if (pokemonHpTexts.isEmpty()) {
            return class_2561.method_43470((String)"\u30d0\u30c8\u30eb\u4e2d...");
        }
        if (pokemonHpTexts.size() == 1) {
            return (class_2561)pokemonHpTexts.get(0);
        }
        class_2561 combinedMessage = (class_2561)pokemonHpTexts.get(0);
        for (int i = 1; i < pokemonHpTexts.size(); ++i) {
            combinedMessage = combinedMessage.method_27661().method_10852((class_2561)class_2561.method_43470((String)" | ").method_27692(class_124.field_1080)).method_10852((class_2561)pokemonHpTexts.get(i));
        }
        return combinedMessage;
    }
}

