/*
 * Decompiled with CFR 0.152.
 */
package io.github.nyankoro328.battle_linker.client.gui;

import io.github.nyankoro328.battle_linker.Battle_linker;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_742;

@Environment(value=EnvType.CLIENT)
public class BattleLinkerScreen
extends class_437 {
    private List<PlayerHeadInfo> playerHeadInfos = new ArrayList<PlayerHeadInfo>();
    private State currentState = State.RULE_SELECTION;
    private String selectedRule;
    private class_1657 selectedPlayer;
    private class_342 levelField;
    private class_4286 noPreviewCheckbox;
    private static final String[] RULES = new String[]{"1v1", "2v2", "3v3", "4v4", "5v5", "6v6", "double"};

    public BattleLinkerScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.battle_linker.title"));
    }

    protected void method_25426() {
        this.method_37067();
        this.playerHeadInfos.clear();
        super.method_25426();
        switch (this.currentState.ordinal()) {
            case 0: {
                this.buildRuleSelectionUi();
                break;
            }
            case 1: {
                this.buildPlayerSelectionUi();
                break;
            }
            case 2: {
                this.buildFinalSettingsUi();
            }
        }
    }

    private void buildRuleSelectionUi() {
        int buttonWidth = 200;
        int buttonHeight = 20;
        int startX = this.field_22789 / 2 - buttonWidth / 2;
        int startY = this.field_22790 / 2 - RULES.length * (buttonHeight + 4) / 2;
        for (int i = 0; i < RULES.length; ++i) {
            String rule = RULES[i];
            String translationKey = "gui.battle_linker.rule." + rule;
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)translationKey), button -> {
                this.selectedRule = rule;
                this.currentState = State.PLAYER_SELECTION;
                this.method_25426();
            }).method_46434(startX, startY + i * (buttonHeight + 4), buttonWidth, buttonHeight).method_46431());
        }
    }

    private void buildPlayerSelectionUi() {
        List selectablePlayers = Objects.requireNonNull(this.field_22787.field_1687).method_18456().stream().filter(player -> player.method_24518(Battle_linker.BATTLE_LINKER_ITEM)).filter(player -> !player.method_5667().equals(this.field_22787.field_1724.method_5667())).collect(Collectors.toList());
        int totalWidth = 200;
        int elementHeight = 20;
        int startX = this.field_22789 / 2 - totalWidth / 2;
        int startY = this.field_22790 / 2 - (selectablePlayers.size() * (elementHeight + 4) + 24) / 2;
        if (selectablePlayers.isEmpty()) {
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.battle_linker.text.no_players_nearby"), button -> {
                this.currentState = State.RULE_SELECTION;
                this.method_25426();
            }).method_46434(startX, startY, totalWidth, elementHeight).method_46431());
            return;
        }
        for (int i = 0; i < selectablePlayers.size(); ++i) {
            class_1657 player2 = (class_1657)selectablePlayers.get(i);
            int yPos = startY + i * (elementHeight + 4);
            int headSize = 20;
            if (player2 instanceof class_742) {
                class_742 clientPlayer = (class_742)player2;
                class_2960 skinTexture = clientPlayer.method_52814().comp_1626();
                this.playerHeadInfos.add(new PlayerHeadInfo(skinTexture, startX, yPos, headSize));
            }
            int buttonX = startX + headSize + 4;
            int buttonWidth = totalWidth - headSize - 4;
            this.method_37063((class_364)class_4185.method_46430((class_2561)player2.method_5477(), button -> {
                this.selectedPlayer = player2;
                this.currentState = State.FINAL_SETTINGS;
                this.method_25426();
            }).method_46434(buttonX, yPos, buttonWidth, elementHeight).method_46431());
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.battle_linker.button.back"), button -> {
            this.currentState = State.RULE_SELECTION;
            this.method_25426();
        }).method_46434(this.field_22789 / 2 - 100, startY + selectablePlayers.size() * (elementHeight + 4) + 4, 98, 20).method_46431());
    }

    private void buildFinalSettingsUi() {
        int elementWidth = 200;
        int startX = this.field_22789 / 2 - elementWidth / 2;
        this.levelField = new class_342(this.field_22793, startX, this.field_22790 / 2 - 40, elementWidth, 20, (class_2561)class_2561.method_43470((String)"Level"));
        this.levelField.method_1852("50");
        this.levelField.method_1890(s -> s.matches("[0-9]*") && (s.isEmpty() || Integer.parseInt(s) <= 100));
        this.method_37063((class_364)this.levelField);
        this.noPreviewCheckbox = class_4286.method_54787((class_2561)class_2561.method_43471((String)"gui.battle_linker.checkbox.nopreview"), (class_327)this.field_22793).method_54789(startX, this.field_22790 / 2 - 10).method_54788();
        this.method_37063((class_364)this.noPreviewCheckbox);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.battle_linker.button.send_challenge"), button -> {
            this.sendCommand();
            this.method_25419();
        }).method_46434(startX, this.field_22790 / 2 + 20, elementWidth, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.battle_linker.button.back"), button -> {
            this.currentState = State.PLAYER_SELECTION;
            this.method_25426();
        }).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 2 + 50, 98, 20).method_46431());
    }

    private void sendCommand() {
        if (this.selectedRule == null || this.selectedPlayer == null || this.levelField.method_1882().isEmpty()) {
            return;
        }
        String level = this.levelField.method_1882();
        String playerName = this.selectedPlayer.method_7334().getName();
        boolean noPreview = this.noPreviewCheckbox.method_20372();
        String command = String.format("challenge%s %s level %s%s", this.selectedRule, playerName, level, noPreview ? " nopreview" : "");
        Objects.requireNonNull(this.field_22787.method_1562()).method_45731(command);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 20, 0xFFFFFF);
        if (this.currentState == State.PLAYER_SELECTION) {
            for (PlayerHeadInfo info : this.playerHeadInfos) {
                context.method_25293(info.skinTexture(), info.x(), info.y(), info.size(), info.size(), 8.0f, 8.0f, 8, 8, 64, 64);
                context.method_25293(info.skinTexture(), info.x(), info.y(), info.size(), info.size(), 40.0f, 8.0f, 8, 8, 64, 64);
            }
        }
        if (this.currentState == State.FINAL_SETTINGS) {
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.battle_linker.label.level"), this.field_22789 / 2 - 100, this.field_22790 / 2 - 50, 0xA0A0A0);
        }
    }

    public boolean method_25421() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    private static enum State {
        RULE_SELECTION,
        PLAYER_SELECTION,
        FINAL_SETTINGS;

    }

    @Environment(value=EnvType.CLIENT)
    private record PlayerHeadInfo(class_2960 skinTexture, int x, int y, int size) {
    }
}

