/*
 * Decompiled with CFR 0.152.
 */
package me.syflog.camenh;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.syflog.camenh.Main;
import me.syflog.camenh.config.Config;
import me.syflog.camenh.duck.IKeyMapping;
import me.syflog.camenh.mixin.ClientInputAccessor;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_10185;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_304;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_6862;

public class Freecam {
    private float speedModifier = 1.0f;
    private double pitch = 0.0;
    private double yaw = 0.0;
    private class_243 oldPosition;
    private class_243 position;
    private Mode mode = Mode.DISABLED;
    private boolean collisions = true;
    private float forwardSpeed = 0.0f;
    private float sideSpeed = 0.0f;
    private float upSpeed = 0.0f;
    private float forwardYaw = 0.0f;
    private float forwardPitch = 0.0f;
    private float sideYaw = 0.0f;
    private TripodPosition[] tripodPositions;
    private class_304 tripodSaveKeyMapping;
    private class_304 tripodLoadKeyMapping;

    public Mode getMode() {
        return this.mode;
    }

    public boolean hasCollisions() {
        return this.collisions;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public boolean isTripodSaveKeyDown() {
        return this.tripodSaveKeyMapping.method_1434();
    }

    public boolean isTripodLoadKeyDown() {
        return this.tripodLoadKeyMapping.method_1434();
    }

    public void updateSpeedModifier(int offset) {
        this.speedModifier += (float)offset / 10.0f;
        this.speedModifier = class_3532.method_15363((float)this.speedModifier, (float)0.5f, (float)4.0f);
        Main.get().overlayMessage("camenh.message.freecamSpeedModifier", String.format("%.01f", Float.valueOf(this.speedModifier)));
    }

    public void resetSpeedModifier() {
        if (this.speedModifier != 1.0f) {
            this.speedModifier = 1.0f;
            Main.get().overlayMessage("camenh.message.freecamSpeedModifier", String.format("%.01f", Float.valueOf(this.speedModifier)));
        }
    }

    public void disable() {
        if (this.mode != Mode.DISABLED) {
            this._disable();
        }
    }

    private void _disable() {
        this.mode = Mode.DISABLED;
    }

    private void _enable() {
        this.speedModifier = 1.0f;
        this.pitch = Main.MC.field_1773.method_19418().method_19329();
        this.yaw = Main.MC.field_1773.method_19418().method_19330();
        this.forwardYaw = this.sideYaw = (float)this.yaw * ((float)Math.PI / 180);
        this.forwardPitch = (float)this.pitch * ((float)Math.PI / 180);
        this.upSpeed = 0.0f;
        this.sideSpeed = 0.0f;
        this.forwardSpeed = 0.0f;
        this.position = this.oldPosition = new class_243(Main.MC.field_1773.method_19418().method_19326().field_1352, Main.MC.field_1773.method_19418().method_19326().field_1351 + (double)(Main.MC.field_1690.method_31044().method_31034() ? Main.MC.field_1724.method_55693() * 0.6f : 0.0f), Main.MC.field_1773.method_19418().method_19326().field_1350);
        Main.MC.field_1724.method_6021();
        Main.MC.field_1724.field_3913.field_54155 = new class_10185(false, false, false, false, false, Main.MC.field_1690.field_1832.method_1434(), false);
        ((ClientInputAccessor)Main.MC.field_1724.field_3913).setMoveVector(class_241.field_1340);
        this.mode = Mode.ENABLED;
    }

    protected Freecam() {
        this.position = this.oldPosition = class_243.field_1353;
        this.tripodPositions = new TripodPosition[9];
        this.tripodSaveKeyMapping = KeyBindingHelper.registerKeyBinding((class_304)new class_304("camenh.keybinds.tripodSave", 66, Main.KEYMAPPING_CATEGORY));
        this.tripodLoadKeyMapping = KeyBindingHelper.registerKeyBinding((class_304)new class_304("camenh.keybinds.tripodLoad", 78, Main.KEYMAPPING_CATEGORY));
        class_304 freecamKeyMapping = KeyBindingHelper.registerKeyBinding((class_304)new class_304("camenh.keybinds.freecam", 86, Main.KEYMAPPING_CATEGORY));
        ((IKeyMapping)freecamKeyMapping).registerKeyDownListener(() -> {
            if (Main.MC.field_1724 == null) {
                return;
            }
            if (this.mode != Mode.DISABLED) {
                this._disable();
            } else {
                this._enable();
            }
        });
    }

    public void saveTripodTo(int i) {
        Main.get().overlayNarratedMessage("camenh.message.tripodPositionSaved", this.tripodLoadKeyMapping.method_16007(), Main.MC.field_1690.field_1852[i].method_16007());
        this.tripodPositions[i] = new TripodPosition(Main.MC.field_1773.method_19418().method_19326().field_1352, Main.MC.field_1773.method_19418().method_19326().field_1351, Main.MC.field_1773.method_19418().method_19326().field_1350, Main.MC.field_1773.method_19418().method_19329(), Main.MC.field_1773.method_19418().method_19330());
    }

    public void enableTripodAt(int i) {
        if (!this.tripodLoadKeyMapping.method_1434() || this.tripodPositions[i] == null) {
            return;
        }
        class_2791 chunk = Main.MC.field_1724.method_73183().method_22350(new class_2338(class_3532.method_15357((double)this.tripodPositions[i].x), class_3532.method_15357((double)this.tripodPositions[i].y), class_3532.method_15357((double)this.tripodPositions[i].z)));
        if (chunk.getClass() != class_2818.class) {
            Main.get().overlayMessage("camenh.message.tripodPositionCannotLoad", new Object[0]);
            return;
        }
        this.position = this.oldPosition = new class_243(this.tripodPositions[i].x, this.tripodPositions[i].y, this.tripodPositions[i].z);
        this.pitch = this.tripodPositions[i].pitch;
        this.yaw = this.tripodPositions[i].yaw;
        this.mode = Mode.TRIPOD;
    }

    public void updateRotation(double yRot, double xRot) {
        this.yaw += yRot * 0.15;
        this.pitch = class_3532.method_15350((double)(this.pitch + xRot * 0.15), (double)-90.0, (double)90.0);
    }

    public class_243 getPosition(float delta) {
        return this.oldPosition.method_35590(this.position, (double)delta);
    }

    public static boolean isCameraInFluid(class_6862<class_3611> fluidTag) {
        class_2338 blockPos = Main.MC.field_1773.method_19418().method_19328();
        class_3610 fluidState = Main.MC.field_1724.method_73183().method_8316(blockPos);
        return fluidState.method_15767(fluidTag) && Main.MC.field_1773.method_19418().method_19326().field_1351 < (double)((float)blockPos.method_10264() + fluidState.method_15763((class_1922)Main.MC.field_1724.method_73183(), blockPos));
    }

    public void tick() {
        class_243 motion;
        float forwardInput = (Main.MC.field_1690.field_1894.method_1434() ? 1.0f : 0.0f) - (Main.MC.field_1690.field_1881.method_1434() ? 1.0f : 0.0f);
        float upInput = (Main.MC.field_1690.field_1903.method_1434() ? 1.0f : 0.0f) - (Main.MC.field_1690.field_1832.method_1434() ? 1.0f : 0.0f);
        float sideInput = (Main.MC.field_1690.field_1849.method_1434() ? 1.0f : 0.0f) - (Main.MC.field_1690.field_1913.method_1434() ? 1.0f : 0.0f);
        float speed = ((Double)Config.options().fcSpeed.method_41753()).floatValue() * this.speedModifier * (Main.MC.field_1690.field_1867.method_1434() ? 2.0f : 1.0f);
        float rampDown = class_3532.method_16439((float)((Double)Config.options().fcMovementSmoothing.method_41753()).floatValue(), (float)0.0f, (float)0.9f);
        float rampUp = class_3532.method_16439((float)((Double)Config.options().fcMovementSmoothing.method_41753()).floatValue(), (float)1.0f, (float)0.15f);
        this.forwardSpeed = Freecam.updateSpeed(this.forwardSpeed, forwardInput, rampUp, rampDown);
        this.upSpeed = Freecam.updateSpeed(this.upSpeed, upInput, rampUp, rampDown * 0.7f);
        this.sideSpeed = Freecam.updateSpeed(this.sideSpeed, sideInput, rampUp, rampDown);
        if (((Boolean)Config.options().fcCreativeFlight.method_41753()).booleanValue()) {
            this.forwardPitch = forwardInput != 0.0f ? (float)this.pitch * ((float)Math.PI / 180) : this.forwardPitch;
            this.forwardYaw = forwardInput != 0.0f ? (float)this.yaw * ((float)Math.PI / 180) : this.forwardYaw;
            this.sideYaw = sideInput != 0.0f ? (float)this.yaw * ((float)Math.PI / 180) : this.sideYaw;
            motion = new class_243((double)(this.forwardSpeed * -class_3532.method_15374((float)this.forwardYaw) - this.sideSpeed * class_3532.method_15362((float)this.sideYaw)), (double)this.upSpeed, (double)(this.forwardSpeed * class_3532.method_15362((float)this.forwardYaw) - this.sideSpeed * class_3532.method_15374((float)this.sideYaw)));
        } else {
            this.forwardPitch = (float)this.pitch * ((float)Math.PI / 180);
            this.forwardYaw = this.sideYaw = (float)this.yaw * ((float)Math.PI / 180);
            motion = new class_243((double)(this.forwardSpeed * -class_3532.method_15362((float)this.forwardPitch) * class_3532.method_15374((float)this.forwardYaw) - this.sideSpeed * class_3532.method_15362((float)this.sideYaw)), (double)(this.forwardSpeed * -class_3532.method_15374((float)this.forwardPitch) + this.upSpeed), (double)(this.forwardSpeed * class_3532.method_15362((float)this.forwardPitch) * class_3532.method_15362((float)this.forwardYaw) - this.sideSpeed * class_3532.method_15374((float)this.sideYaw)));
        }
        double motionLength = motion.method_1033();
        if (motionLength != 0.0) {
            motion = motion.method_1021(Math.min(motionLength, 1.0) / motionLength).method_1021((double)speed);
            motion = this.collisions ? this.updateVecForBBCollisions(motion) : motion;
        }
        this.oldPosition = this.position;
        this.position = this.position.method_1019(motion);
    }

    private static float updateSpeed(float speed, float input, float rampUp, float rampDown) {
        if (input == 0.0f) {
            float newSpeed = speed * rampDown;
            return (double)newSpeed < 1.0E-6 && (double)newSpeed > -1.0E-6 ? 0.0f : newSpeed;
        }
        return class_3532.method_15363((float)(speed + (input < 0.0f ? -rampUp : rampUp)), (float)-1.0f, (float)1.0f);
    }

    private class_243 updateVecForBBCollisions(class_243 vec) {
        boolean moreX;
        if (vec.method_1033() == 0.0) {
            return vec;
        }
        class_238 bb = new class_238(this.position.field_1352 - 0.2, this.position.field_1351 - 0.2, this.position.field_1350 - 0.2, this.position.field_1352 + 0.2, this.position.field_1351 + 0.2, this.position.field_1350 + 0.2);
        List<class_265> colliders = this.buildColliders(bb.method_18804(vec));
        if (colliders.isEmpty()) {
            return vec;
        }
        double x = vec.field_1352;
        double y = vec.field_1351;
        double z = vec.field_1350;
        if (y != 0.0 && (y = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11052, (class_238)bb, colliders, (double)y)) != 0.0) {
            bb = bb.method_989(0.0, y, 0.0);
        }
        boolean bl = moreX = Math.abs(x) < Math.abs(z);
        if (moreX && z != 0.0 && (z = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11051, (class_238)bb, colliders, (double)z)) != 0.0) {
            bb = bb.method_989(0.0, 0.0, z);
        }
        if (x != 0.0) {
            x = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11048, (class_238)bb, colliders, (double)x);
            if (!moreX && x != 0.0) {
                bb = bb.method_989(x, 0.0, 0.0);
            }
        }
        if (!moreX && z != 0.0) {
            z = class_259.method_1085((class_2350.class_2351)class_2350.class_2351.field_11051, (class_238)bb, colliders, (double)z);
        }
        return new class_243(x, y, z);
    }

    private List<class_265> buildColliders(class_238 bb) {
        ImmutableList.Builder colliders = ImmutableList.builder();
        colliders.addAll(Main.MC.field_1724.method_73183().method_20812(null, bb));
        double d = Math.max(class_3532.method_15391((double)bb.method_17939(), (double)bb.method_17941()), 1.0);
        boolean close = Main.MC.field_1724.method_73183().method_8621().method_11961(this.position.field_1352, this.position.field_1350) < d * 2.0;
        boolean within = Main.MC.field_1724.method_73183().method_8621().method_39458(this.position.field_1352, this.position.field_1350, d);
        if (close && within) {
            colliders.add((Object)Main.MC.field_1724.method_73183().method_8621().method_17903());
        }
        return colliders.build();
    }

    public static enum Mode {
        ENABLED,
        TRIPOD,
        DISABLED;

    }

    private record TripodPosition(double x, double y, double z, double pitch, double yaw) {
    }
}

