/*
 * Decompiled with CFR 0.152.
 */
package me.syflog.camenh.config;

import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import me.syflog.camenh.config.ConfigOptions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7172;
import net.minecraft.class_7919;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static Config INSTANCE;
    private File file;
    protected final List<Either<ConfigOption<?>, class_5250>> configList;
    private final String optPrefix;
    private final String catPrefix;
    private final Logger logger;
    private ConfigOptions configOptions;

    public static ConfigOptions options() {
        return Config.INSTANCE.configOptions;
    }

    public static Config get() {
        return INSTANCE;
    }

    public static void init(String modid) {
        if (INSTANCE != null) {
            return;
        }
        INSTANCE = new Config(modid);
    }

    private Config(String modid) {
        this.file = FabricLoader.getInstance().getConfigDir().resolve(modid + ".properties").toFile();
        this.optPrefix = modid + ".config.option.";
        this.catPrefix = modid + ".config.category.";
        this.logger = LoggerFactory.getLogger((String)modid);
        this.configOptions = new ConfigOptions();
        this.configList = new ArrayList();
        this.fillOptions();
        if (!this.file.exists()) {
            this.file.getParentFile().mkdirs();
            this.save();
        } else {
            this.load();
        }
    }

    private void fillOptions() {
        for (Field field : this.configOptions.getClass().getFields()) {
            if (field.isAnnotationPresent(Category.class)) {
                this.configList.add(Either.right((Object)class_2561.method_43471((String)(this.catPrefix + field.getName())).method_27692(class_124.field_1073)));
                continue;
            }
            if (field.isAnnotationPresent(BooleanOption.class)) {
                this.configList.add(Either.left(this.parseBooleanOption(field)));
                continue;
            }
            if (field.isAnnotationPresent(IntegerOption.class)) {
                this.configList.add(Either.left(this.parseIntegerOption(field)));
                continue;
            }
            if (field.isAnnotationPresent(DoubleOption.class)) {
                this.configList.add(Either.left(this.parseDoubleOption(field)));
                continue;
            }
            if (!field.isAnnotationPresent(CyclingOption.class)) continue;
            this.configList.add(Either.left(this.parseCyclingOption(field)));
        }
    }

    private ConfigOption<Boolean> parseBooleanOption(Field field) {
        this.checkField(field, Boolean.class);
        BooleanOption annotation = field.getAnnotation(BooleanOption.class);
        ConfigOption<Boolean> cfgOpt = new ConfigOption<Boolean>();
        cfgOpt.name = field.getName();
        cfgOpt.sameRow = annotation.sameRow();
        cfgOpt.defaultValue = annotation.defaultValue();
        cfgOpt.option = class_7172.method_47604((String)(this.optPrefix + cfgOpt.name), this.tooltip(cfgOpt.name), (component, value) -> {
            if (class_1074.method_4663((String)(this.optPrefix + cfgOpt.name + ".on")) && class_1074.method_4663((String)(this.optPrefix + cfgOpt.name + ".off"))) {
                return value != false ? class_2561.method_43471((String)(this.optPrefix + cfgOpt.name + ".on")) : class_2561.method_43471((String)(this.optPrefix + cfgOpt.name + ".off"));
            }
            return value != false ? class_5244.field_24332 : class_5244.field_24333;
        }, (boolean)((Boolean)cfgOpt.defaultValue), value -> {});
        this.setFieldOption(field, cfgOpt.option);
        return cfgOpt;
    }

    private ConfigOption<Integer> parseIntegerOption(Field field) {
        this.checkField(field, Integer.class);
        IntegerOption annotation = field.getAnnotation(IntegerOption.class);
        int defValue = annotation.defaultValue();
        int min = annotation.min();
        int max = annotation.max();
        int step = annotation.step();
        if (defValue < min || defValue > max) {
            throw new RuntimeException(field.getName() + " - default value outside min/max bounds");
        }
        if (min % step != 0 || max % step != 0) {
            throw new RuntimeException(field.getName() + " - min/max values must be divisible by step");
        }
        if (step < 1 || step > class_3532.method_15382((int)(min - max))) {
            throw new RuntimeException(field.getName() + " - invalid step value");
        }
        ConfigOption<Integer> cfgOpt = new ConfigOption<Integer>();
        cfgOpt.name = field.getName();
        cfgOpt.sameRow = annotation.sameRow();
        cfgOpt.defaultValue = defValue;
        cfgOpt.option = new class_7172(this.optPrefix + cfgOpt.name, this.tooltip(cfgOpt.name), class_315::method_41782, (class_7172.class_7178)new class_7172.class_7174(min / step, max / step).method_42414(i -> i * step, i -> i / step), Codec.intRange((int)min, (int)max), (Object)((Integer)cfgOpt.defaultValue), value -> {});
        this.setFieldOption(field, cfgOpt.option);
        return cfgOpt;
    }

    private ConfigOption<Double> parseDoubleOption(Field field) {
        this.checkField(field, Double.class);
        DoubleOption annotation = field.getAnnotation(DoubleOption.class);
        double defValue = annotation.defaultValue();
        double min = annotation.min();
        double max = annotation.max();
        double inverseStep = 1.0 / annotation.step();
        boolean percent = annotation.percent();
        if (defValue < min || defValue > max) {
            throw new RuntimeException(field.getName() + " - default value outside min/max bounds");
        }
        ConfigOption<Double> cfgOpt = new ConfigOption<Double>();
        cfgOpt.name = field.getName();
        cfgOpt.sameRow = annotation.sameRow();
        cfgOpt.defaultValue = defValue;
        cfgOpt.option = new class_7172(this.optPrefix + cfgOpt.name, this.tooltip(cfgOpt.name), (text, value) -> {
            if (class_1074.method_4663((String)(this.optPrefix + cfgOpt.name + ".min")) && value == min) {
                return class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{text, class_2561.method_43471((String)(this.optPrefix + cfgOpt.name + ".min"))});
            }
            if (class_1074.method_4663((String)(this.optPrefix + cfgOpt.name + ".max")) && value == max) {
                return class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{text, class_2561.method_43471((String)(this.optPrefix + cfgOpt.name + ".max"))});
            }
            if (percent) {
                return class_2561.method_43469((String)"options.percent_value", (Object[])new Object[]{text, Math.round(value * 100.0)});
            }
            return class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{text, value});
        }, (class_7172.class_7178)new class_7172.class_7174((int)(min * inverseStep), (int)(max * inverseStep)).method_42414(value -> (double)value / inverseStep, value -> (int)(value * inverseStep)), Codec.doubleRange((double)min, (double)max), (Object)((Double)cfgOpt.defaultValue), value -> {});
        this.setFieldOption(field, cfgOpt.option);
        return cfgOpt;
    }

    private ConfigOption<Integer> parseCyclingOption(Field field) {
        this.checkField(field, Integer.class);
        CyclingOption annotation = field.getAnnotation(CyclingOption.class);
        int defValueIndex = annotation.defaultValueIndex();
        String[] values = annotation.values();
        if (values.length < 3) {
            throw new RuntimeException(field.getName() + " - cycling needs atleast two values");
        }
        if (defValueIndex < 0 || defValueIndex >= values.length) {
            throw new RuntimeException(field.getName() + " - invalid default value index");
        }
        ConfigOption<Integer> cfgOpt = new ConfigOption<Integer>();
        cfgOpt.name = field.getName();
        cfgOpt.sameRow = annotation.sameRow();
        cfgOpt.defaultValue = defValueIndex;
        cfgOpt.option = new class_7172(this.optPrefix + cfgOpt.name, this.tooltip(cfgOpt.name), (text, value) -> class_2561.method_43471((String)(this.optPrefix + cfgOpt.name + "." + values[value].toString())), (class_7172.class_7178)new class_7172.class_7304(0, () -> values.length - 1, values.length - 1), (Object)((Integer)cfgOpt.defaultValue), value -> {});
        this.setFieldOption(field, cfgOpt.option);
        return cfgOpt;
    }

    private void setFieldOption(Field field, class_7172<?> option) {
        try {
            field.set(this.configOptions, option);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Invalid config field: " + field.getName());
        }
    }

    private void checkField(Field field, Class<?> against) {
        ParameterizedType type;
        Type type2 = field.getGenericType();
        if (type2 instanceof ParameterizedType && (type = (ParameterizedType)type2).getRawType() == class_7172.class && type.getActualTypeArguments().length == 1 && type.getActualTypeArguments()[0] == against) {
            return;
        }
        throw new RuntimeException("Annotation on an invalid field: " + field.getName());
    }

    private <T> class_7172.class_7277<T> tooltip(String id) {
        return value -> class_7919.method_47407((class_2561)(class_1074.method_4663((String)(this.optPrefix + id + ".tooltip")) ? class_2561.method_43471((String)(this.optPrefix + id + ".tooltip")) : class_2561.method_43473()));
    }

    protected List<Either<ConfigOption<?>, class_5250>> getConfigList() {
        return this.configList;
    }

    protected void reset() {
        this.configList.forEach(entry -> entry.ifLeft(option -> option.option.method_41748(option.defaultValue)));
    }

    protected void save() {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8));){
            printWriter.println("# Last saved: " + DateTimeFormatter.ofPattern("HH:mm:ss dd.MM.yyyy").format(LocalDateTime.now()));
            this.configList.forEach(entry -> entry.ifLeft(option -> printWriter.println(option.name + "=" + String.valueOf(option.option.method_41753()))));
        }
        catch (FileNotFoundException e) {
            this.logger.error("Failed to write to '", new Object[]{this.file.getName(), "'!", e.toString()});
        }
    }

    private <T> void parseConfigOption(class_7172<T> option, String value) {
        DataResult dataResult = option.method_42404().parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)value));
        dataResult.error().ifPresent(partialResult -> this.logger.warn("Skipping bad config option (" + value + "): " + partialResult.message()));
        dataResult.result().ifPresent(arg_0 -> option.method_41748(arg_0));
    }

    protected void load() {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file, StandardCharsets.UTF_8));){
            bufferedReader.lines().forEach(line -> {
                if (line.startsWith("#")) {
                    return;
                }
                String[] words = line.split("=");
                if (words.length != 2) {
                    this.logger.warn("Skipping malformed config line!");
                    return;
                }
                String key = words[0];
                String value = words[1];
                this.configList.forEach(entry -> entry.ifLeft(option -> {
                    if (option.name.equals(key)) {
                        this.parseConfigOption(option.option, value);
                    }
                }));
            });
        }
        catch (IOException e) {
            this.logger.error("Failed to read from '", new Object[]{this.file.getName(), "'!", e.toString()});
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface Category {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface BooleanOption {
        public boolean sameRow() default false;

        public boolean defaultValue();
    }

    protected static class ConfigOption<T> {
        String name;
        boolean sameRow;
        T defaultValue;
        class_7172<T> option;

        protected ConfigOption() {
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface IntegerOption {
        public boolean sameRow() default false;

        public int defaultValue();

        public int min();

        public int max();

        public int step() default 1;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface DoubleOption {
        public boolean sameRow() default false;

        public double defaultValue();

        public double min();

        public double max();

        public double step() default 0.01;

        public boolean percent() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface CyclingOption {
        public boolean sameRow() default false;

        public int defaultValueIndex();

        public String[] values();
    }
}

