/*
 * Decompiled with CFR 0.152.
 */
package me.syflog.camenh.mixin;

import java.util.ArrayList;
import java.util.List;
import me.syflog.camenh.duck.IKeyMapping;
import net.minecraft.class_304;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_304.class})
abstract class KeyMappingMixin
implements IKeyMapping {
    @Shadow
    private boolean field_1653;
    private List<IKeyMapping.KeyDownListener> keyDownListeners = new ArrayList<IKeyMapping.KeyDownListener>();
    private List<IKeyMapping.KeyUpListener> keyUpListeners = new ArrayList<IKeyMapping.KeyUpListener>();

    KeyMappingMixin() {
    }

    @Override
    public void onKeyDownEvent() {
        for (IKeyMapping.KeyDownListener l : this.keyDownListeners) {
            l.keyDownListener();
        }
    }

    @Override
    public void onKeyUpEvent() {
        for (IKeyMapping.KeyUpListener l : this.keyUpListeners) {
            l.keyUpListener();
        }
    }

    @Override
    public void registerKeyDownListener(IKeyMapping.KeyDownListener listener) {
        this.keyDownListeners.add(listener);
    }

    @Override
    public void registerKeyUpListener(IKeyMapping.KeyUpListener listener) {
        this.keyUpListeners.add(listener);
    }

    @Inject(method={"setDown"}, at={@At(value="HEAD")})
    public void onSetDown(boolean down, CallbackInfo info) {
        if (down && !this.field_1653) {
            this.onKeyDownEvent();
        } else if (!down && this.field_1653) {
            this.onKeyUpEvent();
        }
    }
}

