/*
 * Decompiled with CFR 0.152.
 */
package com.servergate;

import com.servergate.commands.KeyCommand;
import com.servergate.commands.ServerGateCommand;
import com.servergate.listeners.PlayerJoinListener;
import com.servergate.managers.ConfigManager;
import com.servergate.managers.LockManager;
import com.servergate.utils.WorldUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ServerGatePlugin
extends JavaPlugin {
    private static ServerGatePlugin instance;
    private ConfigManager configManager;
    private LockManager lockManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.lockManager = new LockManager(this);
        if (this.configManager.isEnabled()) {
            WorldUtils.createVoidWorld(this.configManager.getQueueWorld());
        }
        this.getCommand("key").setExecutor((CommandExecutor)new KeyCommand(this));
        this.getCommand("servergate").setExecutor((CommandExecutor)new ServerGateCommand(this));
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(this), (Plugin)this);
        this.getLogger().info("ServerGate enabled!");
    }

    public void onDisable() {
        this.getLogger().info("ServerGate disabled!");
    }

    public static ServerGatePlugin getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.configManager.reload();
        this.lockManager.resetAttempts();
        this.getLogger().info("ServerGate configuration reloaded.");
    }
}

