/*
 * Decompiled with CFR 0.152.
 */
package com.servergate.commands;

import com.servergate.ServerGatePlugin;
import com.servergate.managers.ConfigManager;
import com.servergate.managers.LockManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class KeyCommand
implements CommandExecutor {
    private final ServerGatePlugin plugin;
    private final ConfigManager config;
    private final LockManager lockManager;

    public KeyCommand(ServerGatePlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
        this.lockManager = plugin.getLockManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (!this.config.isEnabled() || player.hasPermission("servergate.bypass")) {
            player.sendMessage(ChatColor.GREEN + "The server is not locked. You don't need a key.");
            return true;
        }
        if (args.length != 1) {
            player.sendMessage(ChatColor.RED + "Usage: /key <code>");
            return true;
        }
        String enteredKey = args[0];
        String correctKey = this.config.getKey();
        if (enteredKey.equals(correctKey)) {
            player.sendMessage(ChatColor.GREEN + "Correct key! Access granted.");
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.lockManager.allowPlayer(player));
            return true;
        }
        int remainingAttempts = this.lockManager.reduceAttempt(player);
        if (remainingAttempts > 0) {
            String msg = this.config.getWrongKeyMessage().replace("%attempts%", String.valueOf(remainingAttempts));
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)msg));
        } else {
            player.kickPlayer(ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getKickMessage()));
        }
        return true;
    }
}

