/*
 * Decompiled with CFR 0.152.
 */
package com.servergate.listeners;

import com.servergate.ServerGatePlugin;
import com.servergate.managers.ConfigManager;
import com.servergate.managers.LockManager;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerJoinListener
implements Listener {
    private final ServerGatePlugin plugin;
    private final ConfigManager config;
    private final LockManager lockManager;

    public PlayerJoinListener(ServerGatePlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
        this.lockManager = plugin.getLockManager();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!this.config.isEnabled() || player.hasPermission("servergate.bypass")) {
            return;
        }
        String joinMsg = this.config.getJoinMessage();
        player.sendMessage(joinMsg);
        World lockWorld = Bukkit.getWorld((String)this.config.getQueueWorld());
        if (lockWorld == null) {
            this.plugin.getLogger().warning("Lock world '" + this.config.getQueueWorld() + "' not found!");
            player.kickPlayer("Server configuration error: lock world missing.");
            return;
        }
        player.teleport(lockWorld.getSpawnLocation());
        player.setGameMode(GameMode.SPECTATOR);
        this.lockManager.startTimeoutCountdown(player);
    }
}

