/*
 * Decompiled with CFR 0.152.
 */
package com.servergate.managers;

import com.servergate.ServerGatePlugin;
import com.servergate.managers.ConfigManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class LockManager {
    private final ServerGatePlugin plugin;
    private final ConfigManager config;
    private final Map<UUID, Integer> attemptsMap = new HashMap<UUID, Integer>();
    private final Map<UUID, BukkitTask> timeoutTasks = new HashMap<UUID, BukkitTask>();

    public LockManager(ServerGatePlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfigManager();
    }

    public void resetAttempts() {
        this.attemptsMap.clear();
        for (BukkitTask task : this.timeoutTasks.values()) {
            task.cancel();
        }
        this.timeoutTasks.clear();
    }

    public int reduceAttempt(Player player) {
        UUID uuid = player.getUniqueId();
        int maxAttempts = this.config.getAttempts();
        int remaining = this.attemptsMap.getOrDefault(uuid, maxAttempts);
        if ((remaining = Math.max(remaining - 1, 0)) == 0) {
            player.kickPlayer(this.config.getKickMessage());
            this.cancelTimeout(player);
            this.attemptsMap.remove(uuid);
        } else {
            this.attemptsMap.put(uuid, remaining);
        }
        return remaining;
    }

    public void startTimeoutCountdown(Player player) {
        UUID uuid = player.getUniqueId();
        this.cancelTimeout(player);
        int timeoutSeconds = this.config.getTimeout();
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.isOnline()) {
                player.kickPlayer(this.config.getTimeoutMessage());
                this.attemptsMap.remove(uuid);
                this.timeoutTasks.remove(uuid);
            }
        }, (long)timeoutSeconds * 20L);
        this.timeoutTasks.put(uuid, task);
    }

    public void cancelTimeout(Player player) {
        BukkitTask task = this.timeoutTasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
    }

    public void allowPlayer(Player player) {
        UUID uuid = player.getUniqueId();
        this.cancelTimeout(player);
        this.attemptsMap.remove(uuid);
        player.teleport(((World)Bukkit.getWorlds().get(0)).getSpawnLocation());
        player.setGameMode(GameMode.SURVIVAL);
    }
}

