/*
 * Decompiled with CFR 0.152.
 */
package nishio.lazuli_lib.core;

import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_293;
import net.minecraft.class_4184;
import net.minecraft.class_9801;
import nishio.lazuli_lib.core.LazuliVertex;
import nishio.lazuli_lib.core.Transform3D;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class LazuliBufferBuilder {
    private class_287 buffer;
    private final Matrix4f matrix4f;
    private Transform3D renderSpace;
    private final boolean useCamera;
    private class_4184 camera = null;
    private final class_289 tessellator;
    private float lastR = 1.0f;
    private float lastG = 1.0f;
    private float lastB = 1.0f;
    private float lastA = 1.0f;
    private float lastU = 0.0f;
    private float lastV = 0.0f;
    private int lastLight = 0;
    private int lastOverlay = 0;
    private float lastNormalX = 0.0f;
    private float lastNormalY = 1.0f;
    private float lastNormalZ = 0.0f;
    private final float clampDist = 500.0f;
    private boolean isEmpty = true;

    public LazuliBufferBuilder(class_289 tessellator, class_293.class_5596 drawMode, class_293 vertexFormat, Matrix4f matrix, Transform3D renderSpace) {
        this.tessellator = tessellator;
        this.buffer = tessellator.method_60827(drawMode, vertexFormat);
        this.matrix4f = matrix;
        this.renderSpace = renderSpace;
        this.useCamera = false;
    }

    public LazuliBufferBuilder(class_289 tessellator, class_293.class_5596 drawMode, class_293 vertexFormat, Matrix4f matrix) {
        this.tessellator = tessellator;
        this.buffer = tessellator.method_60827(drawMode, vertexFormat);
        this.matrix4f = matrix;
        this.renderSpace = Transform3D.ZERO;
        this.useCamera = false;
    }

    public LazuliBufferBuilder(class_293.class_5596 drawMode, class_293 vertexFormat, Matrix4f matrix, Transform3D renderSpace) {
        this.tessellator = class_289.method_1348();
        this.buffer = this.tessellator.method_60827(drawMode, vertexFormat);
        this.matrix4f = matrix;
        this.renderSpace = renderSpace;
        this.useCamera = false;
    }

    public LazuliBufferBuilder(class_293.class_5596 drawMode, class_293 vertexFormat, Matrix4f matrix) {
        this.tessellator = class_289.method_1348();
        this.buffer = this.tessellator.method_60827(drawMode, vertexFormat);
        this.matrix4f = matrix;
        this.renderSpace = Transform3D.ZERO;
        this.useCamera = false;
    }

    public LazuliBufferBuilder(class_289 tessellator, class_293.class_5596 drawMode, class_293 vertexFormat, Matrix4f matrix, Transform3D renderSpace, class_4184 camera) {
        this.tessellator = tessellator;
        this.buffer = tessellator.method_60827(drawMode, vertexFormat);
        this.matrix4f = matrix;
        this.renderSpace = renderSpace;
        this.useCamera = true;
        this.camera = camera;
    }

    public LazuliBufferBuilder(class_289 tessellator, class_293.class_5596 drawMode, class_293 vertexFormat, Matrix4f matrix, class_4184 camera) {
        this.tessellator = tessellator;
        this.buffer = tessellator.method_60827(drawMode, vertexFormat);
        this.matrix4f = matrix;
        this.renderSpace = Transform3D.ZERO;
        this.useCamera = true;
        this.camera = camera;
    }

    public LazuliBufferBuilder(class_293.class_5596 drawMode, class_293 vertexFormat, Matrix4f matrix, Transform3D renderSpace, class_4184 camera) {
        this.tessellator = class_289.method_1348();
        this.buffer = this.tessellator.method_60827(drawMode, vertexFormat);
        this.matrix4f = matrix;
        this.renderSpace = renderSpace;
        this.useCamera = true;
        this.camera = camera;
    }

    public LazuliBufferBuilder(class_293.class_5596 drawMode, class_293 vertexFormat, Matrix4f matrix, class_4184 camera) {
        this.tessellator = class_289.method_1348();
        this.buffer = this.tessellator.method_60827(drawMode, vertexFormat);
        this.matrix4f = matrix;
        this.renderSpace = Transform3D.ZERO;
        this.useCamera = true;
        this.camera = camera;
    }

    public LazuliBufferBuilder(class_287 buffer, Matrix4f matrix, Transform3D renderSpace, class_4184 camera) {
        this.tessellator = class_289.method_1348();
        this.buffer = buffer;
        this.matrix4f = matrix;
        this.renderSpace = Transform3D.ZERO;
        this.useCamera = true;
        this.camera = camera;
    }

    public LazuliBufferBuilder(class_287 buffer, Matrix4f matrix, Transform3D renderSpace) {
        this.tessellator = class_289.method_1348();
        this.buffer = buffer;
        this.matrix4f = matrix;
        this.renderSpace = renderSpace;
        this.useCamera = false;
    }

    public LazuliBufferBuilder(class_287 buffer, Matrix4f matrix) {
        this.tessellator = class_289.method_1348();
        this.buffer = buffer;
        this.matrix4f = matrix;
        this.renderSpace = Transform3D.ZERO;
        this.useCamera = false;
    }

    public class_287 getRaw() {
        return this.buffer;
    }

    public void drawAndReset() {
        if (!this.isEmpty) {
            class_9801 builtBuffer = this.buffer.method_60800();
            class_286.method_43433((class_9801)builtBuffer);
            this.isEmpty = true;
            this.buffer = this.tessellator.method_60827(builtBuffer.method_60822().comp_752(), builtBuffer.method_60822().comp_749());
        }
    }

    public void draw() {
        if (!this.isEmpty) {
            class_286.method_43433((class_9801)this.buffer.method_60800());
            this.isEmpty = true;
        }
    }

    public LazuliBufferBuilder vertex(double x, double y, double z) {
        return this.vertex(new class_243(x, y, z));
    }

    public LazuliBufferBuilder vertex(class_243 vec) {
        class_243 transformed = this.renderSpace.transformPoint(vec);
        this.isEmpty = false;
        if (this.useCamera && this.camera != null) {
            transformed = transformed.method_1020(this.camera.method_19326());
        }
        if (transformed.method_1033() > 500.0) {
            transformed = transformed.method_1029().method_1021(500.0 + 0.002 * (transformed.method_1033() - 500.0));
        }
        this.buffer.method_22918(this.matrix4f, (float)transformed.field_1352, (float)transformed.field_1351, (float)transformed.field_1350);
        return this;
    }

    public LazuliBufferBuilder color(int r, int g, int b, int a) {
        this.buffer.method_1336(r, g, b, a);
        this.lastR = r;
        this.lastG = g;
        this.lastB = b;
        this.lastA = a;
        return this;
    }

    public LazuliBufferBuilder texture(float u, float v) {
        this.buffer.method_22913(u, v);
        this.lastU = u;
        this.lastV = v;
        return this;
    }

    public LazuliBufferBuilder overlay(int overlay) {
        this.buffer.method_22922(overlay);
        this.lastOverlay = overlay;
        return this;
    }

    public LazuliBufferBuilder light(int light) {
        this.buffer.method_60803(light);
        this.lastLight = light;
        return this;
    }

    public LazuliBufferBuilder normal(float x, float y, float z) {
        this.buffer.method_22914(x, y, z);
        this.lastNormalX = x;
        this.lastNormalY = y;
        this.lastNormalZ = z;
        return this;
    }

    public LazuliBufferBuilder normal(class_243 n) {
        this.buffer.method_22914((float)n.field_1352, (float)n.field_1351, (float)n.field_1350);
        this.lastNormalX = (float)n.field_1352;
        this.lastNormalY = (float)n.field_1351;
        this.lastNormalZ = (float)n.field_1350;
        return this;
    }

    public LazuliBufferBuilder addVertex(LazuliVertex v) {
        class_243 pos = v.getPos();
        if (pos != null) {
            this.vertex(pos);
        } else {
            this.vertex(0.0, 0.0, 0.0);
        }
        if (v.r != null) {
            this.lastR = v.r.floatValue();
        }
        if (v.g != null) {
            this.lastG = v.g.floatValue();
        }
        if (v.b != null) {
            this.lastB = v.b.floatValue();
        }
        if (v.a != null) {
            this.lastA = v.a.floatValue();
        }
        this.color((int)(this.lastR * 255.0f), (int)(this.lastG * 255.0f), (int)(this.lastB * 255.0f), (int)(this.lastA * 255.0f));
        if (v.u != null) {
            this.lastU = v.u.floatValue();
        }
        if (v.v != null) {
            this.lastV = v.v.floatValue();
        }
        this.texture(this.lastU, this.lastV);
        if (v.light != null) {
            this.lastLight = v.light;
        }
        this.light(this.lastLight);
        if (v.overlay != null) {
            this.lastOverlay = v.overlay;
        }
        this.overlay(this.lastOverlay);
        if (v.normalX != null) {
            this.lastNormalX = v.normalX.floatValue();
        }
        if (v.normalY != null) {
            this.lastNormalY = v.normalY.floatValue();
        }
        if (v.normalZ != null) {
            this.lastNormalZ = v.normalZ.floatValue();
        }
        Vector3f normal = new Vector3f(this.lastNormalX, this.lastNormalY, this.lastNormalZ);
        normal.rotate((Quaternionfc)this.renderSpace.rotation);
        this.normal(normal.x, normal.y, normal.z);
        return this;
    }

    public void setRenderSpace(Transform3D renderSpace) {
        this.renderSpace = renderSpace;
    }

    public Transform3D getRenderSpace() {
        return this.renderSpace;
    }

    public class_4184 getCamera() {
        return this.camera;
    }

    public void setCamera(class_4184 camera) {
        this.camera = camera;
    }
}

