/*
 * Decompiled with CFR 0.152.
 */
package nishio.lazuli_lib.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;

public class LazuliClock {
    private static long tickCounter = 0L;
    private static final List<ScheduledTask> TASKS = new CopyOnWriteArrayList<ScheduledTask>();

    public static void register() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> {
            ++tickCounter;
            LazuliClock.runTasks();
        });
    }

    public static long ticks() {
        return tickCounter;
    }

    private static float tickDelta() {
        return class_310.method_1551().method_60646().method_60637(true);
    }

    public static float lerpedTicks() {
        return (float)tickCounter + LazuliClock.tickDelta();
    }

    public static float lerpedSeconds() {
        return (float)((double)LazuliClock.lerpedTicks() / 20.0);
    }

    public static Cronometer newCronometer() {
        return new Cronometer();
    }

    public static void schedule(Runnable runnable, long ticks) {
        TASKS.add(new ScheduledTask(tickCounter + ticks, runnable));
    }

    private static void runTasks() {
        for (ScheduledTask task : TASKS) {
            if (task.executeTick > tickCounter) continue;
            task.runnable.run();
            TASKS.remove(task);
        }
    }

    public static class Cronometer {
        private long startTick = LazuliClock.ticks();

        Cronometer() {
        }

        public void start() {
            this.startTick = LazuliClock.ticks();
        }

        public void reset() {
            this.start();
        }

        public long readTicks() {
            return LazuliClock.ticks() - this.startTick;
        }

        public double readSeconds() {
            return (double)this.readTicks() / 20.0;
        }

        public float readLerpedTicks() {
            return LazuliClock.lerpedTicks() - (float)this.startTick;
        }

        public float readLerpedSeconds() {
            return (float)((double)this.readLerpedTicks() / 20.0);
        }

        public void set(long ticks) {
            this.startTick = LazuliClock.ticks() - ticks;
        }
    }

    private record ScheduledTask(long executeTick, Runnable runnable) {
    }
}

