/*
 * Decompiled with CFR 0.152.
 */
package nishio.lazuli_lib.core;

import net.minecraft.class_243;
import net.minecraft.class_4184;
import nishio.lazuli_lib.core.LazuliBufferBuilder;
import nishio.lazuli_lib.core.LazuliMathUtils;
import nishio.lazuli_lib.core.LazuliVertex;
import nishio.lazuli_lib.core.Transform3D;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class LazuliGeometryBuilder {
    private static class_243 mainDisplacement = class_243.field_1353;
    private static double pitch = 0.0;
    private static double yaw = 0.0;
    private static double roll = 0.0;
    private static boolean doLongRangeClamping = true;

    public static void buildTexturedSphere(int res, float radius, class_243 center, class_243 axle, float roll, boolean flipNormals, LazuliBufferBuilder bufferBuilder) {
        float angle2 = 0.0f;
        class_243 xAxle = axle.field_1352 == 0.0 && axle.field_1350 == 0.0 ? new class_243(1.0, 0.0, 0.0) : new class_243(axle.field_1352, 0.0, axle.field_1350).method_1029().method_1024(90.0f);
        class_243 zAxle = LazuliMathUtils.rotateAroundAxis(xAxle, axle, 90.0);
        for (int p = 0; p < res; ++p) {
            float nextAngle2 = angle2 + (float)(Math.PI / (double)res);
            float thisRingRad = (float)Math.sin(angle2) * radius;
            float nextRingRad = (float)Math.sin(nextAngle2) * radius;
            double thisRingY = Math.cos(angle2) * (double)radius;
            double nextRingY = Math.cos(nextAngle2) * (double)radius;
            angle2 = nextAngle2;
            float angle = roll;
            for (int i = 0; i < res * 2; ++i) {
                class_243 v1 = new class_243(Math.sin(angle) * (double)thisRingRad, thisRingY, Math.cos(angle) * (double)thisRingRad);
                class_243 v2 = new class_243(Math.sin(angle) * (double)nextRingRad, nextRingY, Math.cos(angle) * (double)nextRingRad);
                class_243 v3 = new class_243(Math.sin(angle += (float)(Math.PI / (double)res)) * (double)nextRingRad, nextRingY, Math.cos(angle) * (double)nextRingRad);
                class_243 v4 = new class_243(Math.sin(angle) * (double)thisRingRad, thisRingY, Math.cos(angle) * (double)thisRingRad);
                v1 = axle.method_1021(v1.field_1351).method_1019(xAxle.method_1021(v1.field_1352)).method_1019(zAxle.method_1021(v1.field_1350));
                v2 = axle.method_1021(v2.field_1351).method_1019(xAxle.method_1021(v2.field_1352)).method_1019(zAxle.method_1021(v2.field_1350));
                v3 = axle.method_1021(v3.field_1351).method_1019(xAxle.method_1021(v3.field_1352)).method_1019(zAxle.method_1021(v3.field_1350));
                v4 = axle.method_1021(v4.field_1351).method_1019(xAxle.method_1021(v4.field_1352)).method_1019(zAxle.method_1021(v4.field_1350));
                double U1 = (double)(angle - roll) / (Math.PI * 2);
                double U2 = ((double)(angle - roll) + Math.PI / (double)res) / (Math.PI * 2);
                double V1 = (double)nextAngle2 / Math.PI;
                double V2 = ((double)nextAngle2 - Math.PI / (double)res) / Math.PI;
                if (flipNormals) {
                    LazuliGeometryBuilder.addVertexTextureNormal(v4.method_1019(center), U2, V2, v4, bufferBuilder);
                    LazuliGeometryBuilder.addVertexTextureNormal(v3.method_1019(center), U2, V1, v3, bufferBuilder);
                    LazuliGeometryBuilder.addVertexTextureNormal(v2.method_1019(center), U1, V1, v2, bufferBuilder);
                    LazuliGeometryBuilder.addVertexTextureNormal(v1.method_1019(center), U1, V2, v1, bufferBuilder);
                    continue;
                }
                LazuliGeometryBuilder.addVertexTextureNormal(v1.method_1019(center), U1, V2, v1, bufferBuilder);
                LazuliGeometryBuilder.addVertexTextureNormal(v2.method_1019(center), U1, V1, v2, bufferBuilder);
                LazuliGeometryBuilder.addVertexTextureNormal(v3.method_1019(center), U2, V1, v3, bufferBuilder);
                LazuliGeometryBuilder.addVertexTextureNormal(v4.method_1019(center), U2, V2, v4, bufferBuilder);
            }
        }
    }

    public static void buildTexturedSphereRotatedNormal(int res, float radius, class_243 center, class_243 axle, float roll, boolean flipNormals, float normalsRoll, LazuliBufferBuilder bufferBuilder) {
        Transform3D originalSpace = bufferBuilder.getRenderSpace().copy();
        Transform3D sphereSpace = Transform3D.fromPosition(center).rotateAround(axle, roll);
        Transform3D normalRot = Transform3D.ZERO.rotateAround(axle, normalsRoll);
        bufferBuilder.setRenderSpace(sphereSpace);
        float angle2 = 0.0f;
        for (int p = 0; p < res; ++p) {
            float nextAngle2 = angle2 + (float)(Math.PI / (double)res);
            float thisRingRad = (float)Math.sin(angle2) * radius;
            float nextRingRad = (float)Math.sin(nextAngle2) * radius;
            double thisRingY = Math.cos(angle2) * (double)radius;
            double nextRingY = Math.cos(nextAngle2) * (double)radius;
            angle2 = nextAngle2;
            float angle = 0.0f;
            for (int i = 0; i < res * 2; ++i) {
                class_243 v1 = new class_243(Math.sin(angle) * (double)thisRingRad, thisRingY, Math.cos(angle) * (double)thisRingRad);
                class_243 v2 = new class_243(Math.sin(angle) * (double)nextRingRad, nextRingY, Math.cos(angle) * (double)nextRingRad);
                class_243 v3 = new class_243(Math.sin(angle += (float)(Math.PI / (double)res)) * (double)nextRingRad, nextRingY, Math.cos(angle) * (double)nextRingRad);
                class_243 v4 = new class_243(Math.sin(angle) * (double)thisRingRad, thisRingY, Math.cos(angle) * (double)thisRingRad);
                double U1 = ((double)angle - Math.PI / (double)res) / (Math.PI * 2);
                double U2 = (double)angle / (Math.PI * 2);
                double V1 = (double)nextAngle2 / Math.PI;
                double V2 = ((double)nextAngle2 - Math.PI / (double)res) / Math.PI;
                class_243 n1 = normalRot.transformPoint(v1.method_1029());
                class_243 n2 = normalRot.transformPoint(v2.method_1029());
                class_243 n3 = normalRot.transformPoint(v3.method_1029());
                class_243 n4 = normalRot.transformPoint(v4.method_1029());
                LazuliVertex[] quad = new LazuliVertex[]{new LazuliVertex().pos(v1).uv((float)U1, (float)V2).normal(n1), new LazuliVertex().pos(v2).uv((float)U1, (float)V1).normal(n2), new LazuliVertex().pos(v3).uv((float)U2, (float)V1).normal(n3), new LazuliVertex().pos(v4).uv((float)U2, (float)V2).normal(n4)};
                if (flipNormals) {
                    bufferBuilder.addVertex(quad[3]);
                    bufferBuilder.addVertex(quad[2]);
                    bufferBuilder.addVertex(quad[1]);
                    bufferBuilder.addVertex(quad[0]);
                    continue;
                }
                bufferBuilder.addVertex(quad[0]);
                bufferBuilder.addVertex(quad[1]);
                bufferBuilder.addVertex(quad[2]);
                bufferBuilder.addVertex(quad[3]);
            }
        }
        bufferBuilder.setRenderSpace(originalSpace);
    }

    public static void buildRing(float innerRadius, float outerRadius, int segments, class_243 center, class_4184 camera, LazuliBufferBuilder bufferBuilder) {
        class_243 displacement = camera.method_19326().method_1020(center);
        double twoPi = Math.PI * 2;
        for (int i = 0; i < segments; ++i) {
            double a1 = twoPi * (double)i / (double)segments;
            double a2 = twoPi * (double)(i + 1) / (double)segments;
            class_243 inner1 = new class_243(Math.cos(a1) * (double)innerRadius, 0.0, Math.sin(a1) * (double)innerRadius);
            class_243 inner2 = new class_243(Math.cos(a2) * (double)innerRadius, 0.0, Math.sin(a2) * (double)innerRadius);
            class_243 outer1 = new class_243(Math.cos(a1) * (double)outerRadius, 0.0, Math.sin(a1) * (double)outerRadius);
            class_243 outer2 = new class_243(Math.cos(a2) * (double)outerRadius, 0.0, Math.sin(a2) * (double)outerRadius);
            class_243 v1 = inner1.method_1020(displacement);
            class_243 v2 = outer1.method_1020(displacement);
            class_243 v3 = outer2.method_1020(displacement);
            class_243 v4 = inner2.method_1020(displacement);
            float u1 = (float)i / (float)segments;
            float u2 = (float)(i + 1) / (float)segments;
            class_243 n = new class_243(0.0, 1.0, 0.0);
            LazuliGeometryBuilder.addVertexTextureNormal(v1, u1, 0.0, n, bufferBuilder);
            LazuliGeometryBuilder.addVertexTextureNormal(v2, u1, 1.0, n, bufferBuilder);
            LazuliGeometryBuilder.addVertexTextureNormal(v3, u2, 1.0, n, bufferBuilder);
            LazuliGeometryBuilder.addVertexTextureNormal(v4, u2, 0.0, n, bufferBuilder);
        }
    }

    public static void buildSpriteBillboard(class_243 center, class_4184 camera, LazuliBufferBuilder bufferBuilder) {
        class_243 displacement = camera.method_19326().method_1020(center);
        class_243 n = displacement.method_1029();
        LazuliGeometryBuilder.addVertexTextureNormal(class_243.field_1353.method_1020(displacement), 1.0, 1.0, n, bufferBuilder);
        LazuliGeometryBuilder.addVertexTextureNormal(class_243.field_1353.method_1020(displacement), 0.0, 1.0, n, bufferBuilder);
        LazuliGeometryBuilder.addVertexTextureNormal(class_243.field_1353.method_1020(displacement), 0.0, 0.0, n, bufferBuilder);
        LazuliGeometryBuilder.addVertexTextureNormal(class_243.field_1353.method_1020(displacement), 1.0, 0.0, n, bufferBuilder);
    }

    private static void addVertexTextureNormal(class_243 pos, double u, double v, class_243 normal, LazuliBufferBuilder bufferBuilder) {
        normal = normal.method_1029();
        class_243 pos2 = pos.method_1019(mainDisplacement).method_31033((float)yaw).method_1037((float)roll).method_1024((float)pitch);
        class_243 normal2 = normal.method_31033((float)yaw).method_1037((float)roll).method_1024((float)pitch);
        float clamp = 600.0f;
        if (pos2.method_1033() > (double)clamp && doLongRangeClamping) {
            pos2 = pos2.method_1029().method_1021((double)clamp + 0.01 * (pos2.method_1033() - (double)clamp));
        }
        bufferBuilder.addVertex(new LazuliVertex().pos(pos2).uv((float)u, (float)v).normal(normal2));
    }

    public static void displaceRenderingSpacePos(class_243 d) {
        mainDisplacement = mainDisplacement.method_1019(d);
    }

    public static void setRenderingSpacePos(class_243 d) {
        mainDisplacement = d;
    }

    public static void rotatedSpaceDisplaceRenderingSpacePos(class_243 d) {
        mainDisplacement = mainDisplacement.method_1019(d.method_31033((float)(-yaw)).method_1037((float)(-roll)).method_1024((float)(-pitch)));
    }

    public static void displaceRenderingSpaceDir(double dp, double dy, double dr) {
        pitch += dp;
        yaw += dy;
        roll += dr;
    }

    public static void setRenderingSpaceDir(double p, double y, double r) {
        pitch = p;
        yaw = y;
        roll = r;
    }

    public static void enableLongRangeClamping() {
        doLongRangeClamping = true;
    }

    public static void disableLongRangeClamping() {
        doLongRangeClamping = false;
    }

    public static void setLongRangeClamping(boolean b) {
        doLongRangeClamping = b;
    }

    public static boolean checkIfSphereIsVisible(class_243 pos, double radius, class_4184 camera) {
        class_243 camPos = camera.method_19326();
        class_243 toObj = pos.method_1020(camPos);
        double dist2 = toObj.method_1027();
        if (dist2 < 1.0E-4) {
            return true;
        }
        Vector3f camDir = new Vector3f(0.0f, 0.0f, -1.0f);
        camDir.rotate((Quaternionfc)camera.method_23767());
        double dot = (double)camDir.x * toObj.field_1352 + (double)camDir.y * toObj.field_1351 + (double)camDir.z * toObj.field_1350;
        if (dot <= 0.0) {
            return false;
        }
        double visThres = 0.5 - radius / Math.sqrt(dist2);
        return dot / Math.sqrt(dist2) > visThres;
    }

    public static boolean checkIfVisible(class_243 pos, class_4184 camera) {
        class_243 camPos = camera.method_19326();
        class_243 toObj = pos.method_1020(camPos);
        double dist2 = toObj.method_1027();
        if (dist2 < 1.0E-4) {
            return true;
        }
        Vector3f camDir = new Vector3f(0.0f, 0.0f, -1.0f);
        camDir.rotate((Quaternionfc)camera.method_23767());
        double dot = (double)camDir.x * toObj.field_1352 + (double)camDir.y * toObj.field_1351 + (double)camDir.z * toObj.field_1350;
        if (dot <= 0.0) {
            return false;
        }
        double visThres = 0.5 / Math.sqrt(dist2);
        return dot / Math.sqrt(dist2) > visThres;
    }

    public static void buildBox(float sizeX, float sizeY, float sizeZ, class_243 center, class_243 axle, float roll, boolean flipNormals, LazuliBufferBuilder bb) {
        Transform3D old = bb.getRenderSpace().copy();
        bb.setRenderSpace(Transform3D.fromPosition(center).rotateAround(axle, roll));
        float hx = sizeX * 0.5f;
        float hy = sizeY * 0.5f;
        float hz = sizeZ * 0.5f;
        class_243 yAxle = axle.method_1029();
        class_243 xAxle = Math.abs(yAxle.field_1352) < 1.0E-4 && Math.abs(yAxle.field_1350) < 1.0E-4 ? new class_243(1.0, 0.0, 0.0) : new class_243(yAxle.field_1352, 0.0, yAxle.field_1350).method_1029().method_1024(90.0f);
        class_243 zAxle = LazuliMathUtils.rotateAroundAxis(xAxle, yAxle, 90.0);
        class_243[] c = new class_243[8];
        for (int xi = 0; xi < 2; ++xi) {
            for (int yi = 0; yi < 2; ++yi) {
                for (int zi = 0; zi < 2; ++zi) {
                    int idx = xi << 2 | yi << 1 | zi;
                    c[idx] = xAxle.method_1021((double)(xi == 1 ? hx : -hx)).method_1019(yAxle.method_1021((double)(yi == 1 ? hy : -hy))).method_1019(zAxle.method_1021((double)(zi == 1 ? hz : -hz)));
                }
            }
        }
        int[][] faces = new int[][]{{4, 5, 7, 6}, {1, 0, 2, 3}, {2, 6, 7, 3}, {0, 1, 5, 4}, {1, 4, 6, 2}, {5, 0, 3, 7}};
        class_243[] norms = new class_243[]{xAxle, xAxle.method_1021(-1.0), yAxle, yAxle.method_1021(-1.0), zAxle, zAxle.method_1021(-1.0)};
        for (int f = 0; f < 6; ++f) {
            class_243 n = norms[f];
            int[] v = faces[f];
            LazuliVertex[] quad = new LazuliVertex[]{new LazuliVertex().pos(c[v[0]]).uv(0.0f, 0.0f).normal(n), new LazuliVertex().pos(c[v[1]]).uv(1.0f, 0.0f).normal(n), new LazuliVertex().pos(c[v[2]]).uv(1.0f, 1.0f).normal(n), new LazuliVertex().pos(c[v[3]]).uv(0.0f, 1.0f).normal(n)};
            if (flipNormals) {
                bb.addVertex(quad[3]);
                bb.addVertex(quad[2]);
                bb.addVertex(quad[1]);
                bb.addVertex(quad[0]);
                continue;
            }
            bb.addVertex(quad[0]);
            bb.addVertex(quad[1]);
            bb.addVertex(quad[2]);
            bb.addVertex(quad[3]);
        }
        bb.setRenderSpace(old);
    }

    public static void buildCylinder(int segments, float radius, float height, class_243 center, class_243 axle, float roll, boolean capTop, boolean capBottom, boolean flipNormals, LazuliBufferBuilder bb) {
        Transform3D old = bb.getRenderSpace().copy();
        Transform3D cyl = Transform3D.fromPosition(center).rotateAround(axle, roll);
        bb.setRenderSpace(cyl);
        class_243 yAxle = axle.method_1029();
        class_243 xAxle = Math.abs(yAxle.field_1352) < 1.0E-4 && Math.abs(yAxle.field_1350) < 1.0E-4 ? new class_243(1.0, 0.0, 0.0) : new class_243(yAxle.field_1352, 0.0, yAxle.field_1350).method_1029().method_1024(90.0f);
        class_243 zAxle = LazuliMathUtils.rotateAroundAxis(xAxle, yAxle, 90.0);
        float half = height * 0.5f;
        double twoPi = Math.PI * 2;
        for (int i = 0; i < segments; ++i) {
            class_243 n;
            double a1 = twoPi * (double)i / (double)segments;
            double a2 = twoPi * (double)(i + 1) / (double)segments;
            class_243 rim1 = xAxle.method_1021(Math.cos(a1) * (double)radius).method_1019(zAxle.method_1021(Math.sin(a1) * (double)radius));
            class_243 rim2 = xAxle.method_1021(Math.cos(a2) * (double)radius).method_1019(zAxle.method_1021(Math.sin(a2) * (double)radius));
            class_243 v1 = rim1.method_1019(yAxle.method_1021((double)(-half)));
            class_243 v2 = rim2.method_1019(yAxle.method_1021((double)(-half)));
            class_243 v3 = rim2.method_1019(yAxle.method_1021((double)half));
            class_243 v4 = rim1.method_1019(yAxle.method_1021((double)half));
            if (flipNormals) {
                LazuliGeometryBuilder.addVertexTextureNormal(v4, (double)(i + 1) / (double)segments, 1.0, rim1.method_1029(), bb);
                LazuliGeometryBuilder.addVertexTextureNormal(v3, (double)(i + 1) / (double)segments, 0.0, rim2.method_1029(), bb);
                LazuliGeometryBuilder.addVertexTextureNormal(v2, (double)i / (double)segments, 0.0, rim2.method_1029(), bb);
                LazuliGeometryBuilder.addVertexTextureNormal(v1, (double)i / (double)segments, 1.0, rim1.method_1029(), bb);
            } else {
                LazuliGeometryBuilder.addVertexTextureNormal(v1, (double)i / (double)segments, 1.0, rim1.method_1029(), bb);
                LazuliGeometryBuilder.addVertexTextureNormal(v2, (double)i / (double)segments, 0.0, rim2.method_1029(), bb);
                LazuliGeometryBuilder.addVertexTextureNormal(v3, (double)(i + 1) / (double)segments, 0.0, rim2.method_1029(), bb);
                LazuliGeometryBuilder.addVertexTextureNormal(v4, (double)(i + 1) / (double)segments, 1.0, rim1.method_1029(), bb);
            }
            if (capTop) {
                class_243 topCenter = yAxle.method_1021((double)half);
                n = yAxle;
                if (flipNormals) {
                    n = n.method_1021(-1.0);
                }
                LazuliGeometryBuilder.addVertexTextureNormal(topCenter, 0.5, 0.5, n, bb);
                LazuliGeometryBuilder.addVertexTextureNormal(rim2.method_1019(yAxle.method_1021((double)half)), Math.cos(a2) * 0.5 + 0.5, Math.sin(a2) * 0.5 + 0.5, n, bb);
                LazuliGeometryBuilder.addVertexTextureNormal(rim1.method_1019(yAxle.method_1021((double)half)), Math.cos(a1) * 0.5 + 0.5, Math.sin(a1) * 0.5 + 0.5, n, bb);
            }
            if (!capBottom) continue;
            class_243 botCenter = yAxle.method_1021((double)(-half));
            n = yAxle.method_1021(-1.0);
            if (flipNormals) {
                n = n.method_1021(-1.0);
            }
            LazuliGeometryBuilder.addVertexTextureNormal(botCenter, 0.5, 0.5, n, bb);
            LazuliGeometryBuilder.addVertexTextureNormal(rim1.method_1019(yAxle.method_1021((double)(-half))), Math.cos(a1) * 0.5 + 0.5, Math.sin(a1) * 0.5 + 0.5, n, bb);
            LazuliGeometryBuilder.addVertexTextureNormal(rim2.method_1019(yAxle.method_1021((double)(-half))), Math.cos(a2) * 0.5 + 0.5, Math.sin(a2) * 0.5 + 0.5, n, bb);
        }
        bb.setRenderSpace(old);
    }

    public static void buildCone(int segments, float radius, float height, class_243 tip, class_243 axle, boolean flipNormals, LazuliBufferBuilder bb) {
        Transform3D old = bb.getRenderSpace().copy();
        Transform3D space = Transform3D.fromPosition(tip).rotateAround(axle, 0.0f);
        bb.setRenderSpace(space);
        class_243 yAxle = axle.method_1029();
        class_243 xAxle = Math.abs(yAxle.field_1352) < 1.0E-4 && Math.abs(yAxle.field_1350) < 1.0E-4 ? new class_243(1.0, 0.0, 0.0) : new class_243(yAxle.field_1352, 0.0, yAxle.field_1350).method_1029().method_1024(90.0f);
        class_243 zAxle = LazuliMathUtils.rotateAroundAxis(xAxle, yAxle, 90.0);
        class_243 baseCenter = yAxle.method_1021((double)height);
        double twoPi = Math.PI * 2;
        for (int i = 0; i < segments; ++i) {
            double a1 = twoPi * (double)i / (double)segments;
            double a2 = twoPi * (double)(i + 1) / (double)segments;
            class_243 rim1 = baseCenter.method_1019(xAxle.method_1021(Math.cos(a1) * (double)radius)).method_1019(zAxle.method_1021(Math.sin(a1) * (double)radius));
            class_243 rim2 = baseCenter.method_1019(xAxle.method_1021(Math.cos(a2) * (double)radius)).method_1019(zAxle.method_1021(Math.sin(a2) * (double)radius));
            class_243 n1 = rim1.method_1020(class_243.field_1353).method_1036(rim2.method_1020(class_243.field_1353)).method_1029();
            if (flipNormals) {
                n1 = n1.method_1021(-1.0);
            }
            if (flipNormals) {
                LazuliGeometryBuilder.addVertexTextureNormal(rim2, 1.0, 0.0, n1, bb);
                LazuliGeometryBuilder.addVertexTextureNormal(rim1, 0.0, 0.0, n1, bb);
                LazuliGeometryBuilder.addVertexTextureNormal(class_243.field_1353, 0.5, 1.0, n1, bb);
            } else {
                LazuliGeometryBuilder.addVertexTextureNormal(class_243.field_1353, 0.5, 1.0, n1, bb);
                LazuliGeometryBuilder.addVertexTextureNormal(rim1, 0.0, 0.0, n1, bb);
                LazuliGeometryBuilder.addVertexTextureNormal(rim2, 1.0, 0.0, n1, bb);
            }
            class_243 nBase = yAxle;
            if (flipNormals) {
                nBase = nBase.method_1021(-1.0);
            }
            LazuliGeometryBuilder.addVertexTextureNormal(baseCenter, 0.5, 0.5, nBase, bb);
            LazuliGeometryBuilder.addVertexTextureNormal(rim1, Math.cos(a1) * 0.5 + 0.5, Math.sin(a1) * 0.5 + 0.5, nBase, bb);
            LazuliGeometryBuilder.addVertexTextureNormal(rim2, Math.cos(a2) * 0.5 + 0.5, Math.sin(a2) * 0.5 + 0.5, nBase, bb);
        }
        bb.setRenderSpace(old);
    }

    public static void buildTorus(int resMajor, int resTube, float majorR, float tubeR, class_243 center, class_243 axle, float roll, boolean flipNormals, LazuliBufferBuilder bb) {
        Transform3D old = bb.getRenderSpace().copy();
        Transform3D space = Transform3D.fromPosition(center).rotateAround(axle, roll);
        bb.setRenderSpace(space);
        class_243 yAxle = axle.method_1029();
        class_243 xAxle = Math.abs(yAxle.field_1352) < 1.0E-4 && Math.abs(yAxle.field_1350) < 1.0E-4 ? new class_243(1.0, 0.0, 0.0) : new class_243(yAxle.field_1352, 0.0, yAxle.field_1350).method_1029().method_1024(90.0f);
        class_243 zAxle = LazuliMathUtils.rotateAroundAxis(xAxle, yAxle, 90.0);
        double twoPi = Math.PI * 2;
        for (int m = 0; m < resMajor; ++m) {
            double a0 = twoPi * (double)m / (double)resMajor;
            double a1 = twoPi * (double)(m + 1) / (double)resMajor;
            class_243 c0 = xAxle.method_1021(Math.cos(a0) * (double)majorR).method_1019(zAxle.method_1021(Math.sin(a0) * (double)majorR));
            class_243 c1 = xAxle.method_1021(Math.cos(a1) * (double)majorR).method_1019(zAxle.method_1021(Math.sin(a1) * (double)majorR));
            for (int t = 0; t < resTube; ++t) {
                double b0 = twoPi * (double)t / (double)resTube;
                double b1 = twoPi * (double)(t + 1) / (double)resTube;
                class_243 n00 = xAxle.method_1021(Math.cos(a0) * Math.cos(b0)).method_1019(zAxle.method_1021(Math.sin(a0) * Math.cos(b0))).method_1019(yAxle.method_1021(Math.sin(b0)));
                class_243 n01 = xAxle.method_1021(Math.cos(a0) * Math.cos(b1)).method_1019(zAxle.method_1021(Math.sin(a0) * Math.cos(b1))).method_1019(yAxle.method_1021(Math.sin(b1)));
                class_243 n10 = xAxle.method_1021(Math.cos(a1) * Math.cos(b0)).method_1019(zAxle.method_1021(Math.sin(a1) * Math.cos(b0))).method_1019(yAxle.method_1021(Math.sin(b0)));
                class_243 n11 = xAxle.method_1021(Math.cos(a1) * Math.cos(b1)).method_1019(zAxle.method_1021(Math.sin(a1) * Math.cos(b1))).method_1019(yAxle.method_1021(Math.sin(b1)));
                class_243 v00 = c0.method_1019(n00.method_1021((double)tubeR));
                class_243 v01 = c0.method_1019(n01.method_1021((double)tubeR));
                class_243 v10 = c1.method_1019(n10.method_1021((double)tubeR));
                class_243 v11 = c1.method_1019(n11.method_1021((double)tubeR));
                double U0 = (double)m / (double)resMajor;
                double U1 = (double)(m + 1) / (double)resMajor;
                double V0 = (double)t / (double)resTube;
                double V1 = (double)(t + 1) / (double)resTube;
                if (flipNormals) {
                    LazuliGeometryBuilder.addVertexTextureNormal(v11, U1, V1, n11, bb);
                    LazuliGeometryBuilder.addVertexTextureNormal(v10, U1, V0, n10, bb);
                    LazuliGeometryBuilder.addVertexTextureNormal(v00, U0, V0, n00, bb);
                    LazuliGeometryBuilder.addVertexTextureNormal(v01, U0, V1, n01, bb);
                    continue;
                }
                LazuliGeometryBuilder.addVertexTextureNormal(v00, U0, V0, n00, bb);
                LazuliGeometryBuilder.addVertexTextureNormal(v10, U1, V0, n10, bb);
                LazuliGeometryBuilder.addVertexTextureNormal(v11, U1, V1, n11, bb);
                LazuliGeometryBuilder.addVertexTextureNormal(v01, U0, V1, n01, bb);
            }
        }
        bb.setRenderSpace(old);
    }

    public static void buildCapsule(int res, float radius, float height, class_243 center, class_243 axle, float roll, boolean flipNormals, class_4184 camera, LazuliBufferBuilder bb) {
        LazuliGeometryBuilder.buildCylinder(res, radius, height - 2.0f * radius, center, axle, roll, false, false, flipNormals, bb);
        class_243 topCenter = center.method_1019(axle.method_1029().method_1021((double)((height - radius * 2.0f) * 0.5f + radius)));
        class_243 bottomCenter = center.method_1019(axle.method_1029().method_1021((double)(-(height - radius * 2.0f) * 0.5f - radius)));
        LazuliGeometryBuilder.buildTexturedSphere(res, radius, topCenter, axle, roll, flipNormals, bb);
        LazuliGeometryBuilder.buildTexturedSphere(res, radius, bottomCenter, axle.method_1021(-1.0), roll, flipNormals, bb);
    }
}

