/*
 * Decompiled with CFR 0.152.
 */
package nishio.lazuli_lib.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_276;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_2973;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3518;
import net.minecraft.class_5912;
import net.minecraft.class_6367;
import nishio.lazuli_lib.internals.LazuliPostEffectPass;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class LazuliPostEffectShader
implements AutoCloseable {
    public static final String MAIN_TARGET_NAME = "minecraft:main";
    public final class_276 mainTarget;
    public final class_5912 resourceFactory;
    public final String name;
    public final List<LazuliPostEffectPass> passes = Lists.newArrayList();
    public final Map<String, class_276> targetsByName = Maps.newHashMap();
    public final List<class_276> defaultSizedTargets = Lists.newArrayList();
    public Matrix4f projectionMatrix;
    public int width;
    public int height;
    public float time;
    public float lastTickDelta;

    public LazuliPostEffectShader(class_1060 textureManager, class_5912 resourceFactory, class_276 framebuffer, class_2960 id) throws IOException, JsonSyntaxException {
        this.resourceFactory = resourceFactory;
        this.mainTarget = framebuffer;
        this.time = 0.0f;
        this.lastTickDelta = 0.0f;
        this.width = framebuffer.field_1480;
        this.height = framebuffer.field_1477;
        this.name = id.toString();
        this.setupProjectionMatrix();
        this.parseEffect(textureManager, id);
    }

    private void parseEffect(class_1060 textureManager, class_2960 id) throws IOException, JsonSyntaxException {
        block15: {
            class_3298 resource = this.resourceFactory.getResourceOrThrow(id);
            try (BufferedReader reader = resource.method_43039();){
                int i;
                JsonArray jsonArray;
                JsonObject jsonObject = class_3518.method_15255((Reader)reader);
                if (class_3518.method_15264((JsonObject)jsonObject, (String)"targets")) {
                    jsonArray = jsonObject.getAsJsonArray("targets");
                    i = 0;
                    for (JsonElement jsonElement : jsonArray) {
                        try {
                            this.parseTarget(jsonElement);
                        }
                        catch (Exception exception) {
                            class_2973 invalidHierarchicalFileException = class_2973.method_12856((Exception)exception);
                            invalidHierarchicalFileException.method_12854("targets[" + i + "]");
                            throw invalidHierarchicalFileException;
                        }
                        ++i;
                    }
                }
                if (!class_3518.method_15264((JsonObject)jsonObject, (String)"passes")) break block15;
                jsonArray = jsonObject.getAsJsonArray("passes");
                i = 0;
                for (JsonElement jsonElement : jsonArray) {
                    try {
                        this.parsePass(textureManager, jsonElement);
                    }
                    catch (Exception exception) {
                        class_2973 invalidHierarchicalFileException = class_2973.method_12856((Exception)exception);
                        invalidHierarchicalFileException.method_12854("passes[" + i + "]");
                        throw invalidHierarchicalFileException;
                    }
                    ++i;
                }
            }
            catch (Exception exception2) {
                class_2973 invalidHierarchicalFileException2 = class_2973.method_12856((Exception)exception2);
                String var10001 = id.method_12832();
                invalidHierarchicalFileException2.method_12855(var10001 + " (" + resource.method_14480() + ")");
                throw invalidHierarchicalFileException2;
            }
        }
    }

    private void parseTarget(JsonElement jsonTarget) throws class_2973 {
        if (class_3518.method_15286((JsonElement)jsonTarget)) {
            this.addTarget(jsonTarget.getAsString(), this.width, this.height);
        } else {
            JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonTarget, (String)"target");
            String string = class_3518.method_15265((JsonObject)jsonObject, (String)"name");
            int i = class_3518.method_15282((JsonObject)jsonObject, (String)"width", (int)this.width);
            int j = class_3518.method_15282((JsonObject)jsonObject, (String)"height", (int)this.height);
            if (this.targetsByName.containsKey(string)) {
                throw new class_2973(string + " is already defined");
            }
            this.addTarget(string, i, j);
        }
    }

    private void parsePass(class_1060 textureManager, JsonElement jsonPass) throws IOException {
        JsonArray jsonArray2;
        JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonPass, (String)"pass");
        String string = class_3518.method_15265((JsonObject)jsonObject, (String)"name");
        String string2 = class_3518.method_15265((JsonObject)jsonObject, (String)"intarget");
        String string3 = class_3518.method_15265((JsonObject)jsonObject, (String)"outtarget");
        class_276 framebuffer = this.getTarget(string2);
        class_276 framebuffer2 = this.getTarget(string3);
        boolean bl = class_3518.method_15258((JsonObject)jsonObject, (String)"use_linear_filter", (boolean)false);
        if (framebuffer == null) {
            throw new class_2973("Input target '" + string2 + "' does not exist");
        }
        if (framebuffer2 == null) {
            throw new class_2973("Output target '" + string3 + "' does not exist");
        }
        LazuliPostEffectPass postEffectPass = this.addPass(string, framebuffer, framebuffer2, bl);
        JsonArray jsonArray = class_3518.method_15292((JsonObject)jsonObject, (String)"auxtargets", (JsonArray)null);
        if (jsonArray != null) {
            int i = 0;
            for (JsonElement jsonElement : jsonArray) {
                try {
                    String string6;
                    boolean bl2;
                    JsonObject jsonObject2 = class_3518.method_15295((JsonElement)jsonElement, (String)"auxtarget");
                    String string4 = class_3518.method_15265((JsonObject)jsonObject2, (String)"name");
                    String string5 = class_3518.method_15265((JsonObject)jsonObject2, (String)"id");
                    if (string5.endsWith(":depth")) {
                        bl2 = true;
                        string6 = string5.substring(0, string5.lastIndexOf(58));
                    } else {
                        bl2 = false;
                        string6 = string5;
                    }
                    class_276 framebuffer3 = this.getTarget(string6);
                    if (framebuffer3 == null) {
                        if (bl2) {
                            throw new class_2973("Render target '" + string6 + "' can't be used as depth buffer");
                        }
                        class_2960 identifier = class_2960.method_60656((String)("textures/effect/" + string6 + ".png"));
                        this.resourceFactory.method_14486(identifier).orElseThrow(() -> new class_2973("Render target or texture '" + string6 + "' does not exist"));
                        RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
                        textureManager.method_22813(identifier);
                        class_1044 abstractTexture = textureManager.method_4619(identifier);
                        int j = class_3518.method_15260((JsonObject)jsonObject2, (String)"width");
                        int k = class_3518.method_15260((JsonObject)jsonObject2, (String)"height");
                        boolean bl3 = class_3518.method_15270((JsonObject)jsonObject2, (String)"bilinear");
                        if (bl3) {
                            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
                            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
                        } else {
                            RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
                            RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
                        }
                        Objects.requireNonNull(abstractTexture);
                        postEffectPass.addAuxTarget(string4, () -> ((class_1044)abstractTexture).method_4624(), j, k);
                    } else if (bl2) {
                        Objects.requireNonNull(framebuffer3);
                        postEffectPass.addAuxTarget(string4, () -> ((class_276)framebuffer3).method_30278(), framebuffer3.field_1482, framebuffer3.field_1481);
                    } else {
                        Objects.requireNonNull(framebuffer3);
                        postEffectPass.addAuxTarget(string4, () -> ((class_276)framebuffer3).method_30277(), framebuffer3.field_1482, framebuffer3.field_1481);
                    }
                }
                catch (Exception exception) {
                    class_2973 invalidHierarchicalFileException = class_2973.method_12856((Exception)exception);
                    invalidHierarchicalFileException.method_12854("auxtargets[" + i + "]");
                    throw invalidHierarchicalFileException;
                }
                ++i;
            }
        }
        if ((jsonArray2 = class_3518.method_15292((JsonObject)jsonObject, (String)"uniforms", (JsonArray)null)) != null) {
            int l = 0;
            for (JsonElement jsonElement2 : jsonArray2) {
                try {
                    this.parseUniform(jsonElement2);
                }
                catch (Exception exception2) {
                    class_2973 invalidHierarchicalFileException2 = class_2973.method_12856((Exception)exception2);
                    invalidHierarchicalFileException2.method_12854("uniforms[" + l + "]");
                    throw invalidHierarchicalFileException2;
                }
                ++l;
            }
        }
    }

    void parseUniform(JsonElement jsonUniform) throws class_2973 {
        JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonUniform, (String)"uniform");
        String string = class_3518.method_15265((JsonObject)jsonObject, (String)"name");
        class_284 glUniform = this.passes.get(this.passes.size() - 1).getProgram().method_1271(string);
        if (glUniform == null) {
            throw new class_2973("Uniform '" + string + "' does not exist");
        }
        float[] fs = new float[4];
        int i = 0;
        for (JsonElement jsonElement : class_3518.method_15261((JsonObject)jsonObject, (String)"values")) {
            try {
                fs[i] = class_3518.method_15269((JsonElement)jsonElement, (String)"value");
            }
            catch (Exception exception) {
                class_2973 invalidHierarchicalFileException = class_2973.method_12856((Exception)exception);
                invalidHierarchicalFileException.method_12854("values[" + i + "]");
                throw invalidHierarchicalFileException;
            }
            ++i;
        }
        switch (i) {
            default: {
                break;
            }
            case 1: {
                glUniform.method_1251(fs[0]);
                break;
            }
            case 2: {
                glUniform.method_1255(fs[0], fs[1]);
                break;
            }
            case 3: {
                glUniform.method_1249(fs[0], fs[1], fs[2]);
                break;
            }
            case 4: {
                glUniform.method_1254(fs[0], fs[1], fs[2], fs[3]);
            }
        }
    }

    public class_276 getSecondaryTarget(String name) {
        return this.targetsByName.get(name);
    }

    public void addTarget(String name, int width, int height) {
        class_6367 framebuffer = new class_6367(width, height, true, class_310.field_1703);
        framebuffer.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
        this.targetsByName.put(name, (class_276)framebuffer);
        if (width == this.width && height == this.height) {
            this.defaultSizedTargets.add((class_276)framebuffer);
        }
    }

    @Override
    public void close() {
        for (class_276 framebuffer : this.targetsByName.values()) {
            framebuffer.method_1238();
        }
        for (LazuliPostEffectPass postEffectPass : this.passes) {
            postEffectPass.close();
        }
        this.passes.clear();
    }

    public LazuliPostEffectPass addPass(String programName, class_276 source, class_276 dest, boolean linear) throws IOException {
        LazuliPostEffectPass postEffectPass = new LazuliPostEffectPass(this.resourceFactory, programName, source, dest, linear);
        this.passes.add(this.passes.size(), postEffectPass);
        return postEffectPass;
    }

    void setupProjectionMatrix() {
        this.projectionMatrix = new Matrix4f().setOrtho(0.0f, (float)this.mainTarget.field_1482, 0.0f, (float)this.mainTarget.field_1481, 0.1f, 1000.0f);
    }

    public void setupDimensions(int targetsWidth, int targetsHeight) {
        this.width = this.mainTarget.field_1482;
        this.height = this.mainTarget.field_1481;
        this.setupProjectionMatrix();
        for (LazuliPostEffectPass postEffectPass : this.passes) {
            postEffectPass.setProjectionMatrix(this.projectionMatrix);
        }
        for (class_276 framebuffer : this.defaultSizedTargets) {
            framebuffer.method_1234(targetsWidth, targetsHeight, class_310.field_1703);
        }
    }

    void setTexFilter(int texFilter) {
        this.mainTarget.method_58226(texFilter);
        for (class_276 framebuffer : this.targetsByName.values()) {
            framebuffer.method_58226(texFilter);
        }
    }

    public void render(float tickDelta) {
        this.time += tickDelta;
        while (this.time > 20.0f) {
            this.time -= 20.0f;
        }
        int i = 9728;
        for (LazuliPostEffectPass postEffectPass : this.passes) {
            int j = postEffectPass.getTexFilter();
            if (i != j) {
                this.setTexFilter(j);
                i = j;
            }
            postEffectPass.render(this.time / 20.0f);
        }
        this.setTexFilter(9728);
    }

    public void setUniforms(String name, float value) {
        for (LazuliPostEffectPass postEffectPass : this.passes) {
            postEffectPass.getProgram().method_1275(name).method_1251(value);
        }
    }

    public final String getName() {
        return this.name;
    }

    @Nullable
    class_276 getTarget(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return name.equals(MAIN_TARGET_NAME) ? this.mainTarget : this.targetsByName.get(name);
    }
}

