/*
 * Decompiled with CFR 0.152.
 */
package nishio.lazuli_lib.core;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_6854;
import net.minecraft.class_757;
import nishio.lazuli_lib.core.LazuliRenderEvents;
import org.joml.Matrix4d;
import org.joml.Matrix4f;

public class LazuliRenderingRegistry {
    private static class_4184 camera;
    private static Matrix4f customViewProj;
    private static final List<LazuliRenderEvents.LazuliRenderCallback> RENDER_CALLBACKS;
    private static final List<LazuliRenderEvents.LazuliPostCallback> POST_CALLBACKS;
    public static final AtomicReference<Float> time;
    private static boolean wasZooming;
    private static Matrix4f matrix4f;
    public static final class_2960 CELESTIAL_SYNC;

    public static void registerLazuliRenderPhases() {
        WorldRenderEvents.LAST.register(context -> {
            camera = context.camera();
            matrix4f = context.positionMatrix();
            if (camera == null || matrix4f == null) {
                return;
            }
            float tickDelta = context.tickCounter().method_60637(true);
            class_289 tessellator = class_289.method_1348();
            time.updateAndGet(v -> Float.valueOf(v.floatValue() + tickDelta));
            class_4587 ms = new class_4587();
            ms.method_34425(matrix4f);
            ms.method_22903();
            ms.method_22907(camera.method_23767());
            Matrix4f viewProj = ms.method_23760().method_23761();
            for (LazuliRenderEvents.LazuliRenderCallback lazuliRenderCallback : RENDER_CALLBACKS) {
                lazuliRenderCallback.render(context, viewProj, tickDelta);
            }
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.setShaderFogShape((class_6854)class_6854.field_36351);
            RenderSystem.setShaderFogColor((float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.enableDepthTest();
            for (LazuliRenderEvents.LazuliPostCallback lazuliPostCallback : POST_CALLBACKS) {
                lazuliPostCallback.post(context, customViewProj, tickDelta);
            }
        });
    }

    public static void registerRenderCallback(LazuliRenderEvents.LazuliRenderCallback callback) {
        RENDER_CALLBACKS.add(callback);
    }

    public static void registerPostCallback(LazuliRenderEvents.LazuliPostCallback callback) {
        POST_CALLBACKS.add(callback);
    }

    private static Matrix4f convertMatrix4dToMatrix4f(Matrix4d d) {
        return new Matrix4f((float)d.m00(), (float)d.m01(), (float)d.m02(), (float)d.m03(), (float)d.m10(), (float)d.m11(), (float)d.m12(), (float)d.m13(), (float)d.m20(), (float)d.m21(), (float)d.m22(), (float)d.m23(), (float)d.m30(), (float)d.m31(), (float)d.m32(), (float)d.m33());
    }

    static {
        RENDER_CALLBACKS = new CopyOnWriteArrayList<LazuliRenderEvents.LazuliRenderCallback>();
        POST_CALLBACKS = new CopyOnWriteArrayList<LazuliRenderEvents.LazuliPostCallback>();
        time = new AtomicReference<Float>(Float.valueOf(0.0f));
        wasZooming = false;
        CELESTIAL_SYNC = class_2960.method_60655((String)"new_horizons", (String)"celestial_sync");
    }
}

