/*
 * Decompiled with CFR 0.152.
 */
package nishio.lazuli_lib.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.minecraft.class_1041;
import net.minecraft.class_276;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5944;
import nishio.lazuli_lib.Lazuli_Lib_Client;
import nishio.lazuli_lib.core.LazuliPostEffectShader;
import nishio.lazuli_lib.core.LazuliPostProcessingRegistry;

public class LazuliShaderRegistry {
    private static final Map<String, class_5944> SHADER_MAP = new HashMap<String, class_5944>();
    private static final Map<String, LazuliPostEffectShader> POST_PROCESSOR_MAP = new HashMap<String, LazuliPostEffectShader>();
    private static int resX;
    private static int resY;

    public static void registerShader(String name, String nameSpace, class_293 format) {
        class_2960 shaderId = class_2960.method_60655((String)nameSpace, (String)name);
        CoreShaderRegistrationCallback.EVENT.register(ctx -> ctx.register(shaderId, format, shaderProgram -> {
            SHADER_MAP.put(name, (class_5944)shaderProgram);
            Lazuli_Lib_Client.LOGGER.info("Shader '{}' registered!", (Object)name);
        }));
    }

    public static void registerPostProcessingShader(String name, String nameSpace) {
        Lazuli_Lib_Client.LOGGER.info("Trying to register {}", (Object)name);
        LazuliPostProcessingRegistry.register((client, factory) -> {
            class_2960 shaderId = class_2960.method_60655((String)nameSpace, (String)name);
            class_276 framebuffer = client.method_1522();
            try {
                LazuliPostEffectShader processor = new LazuliPostEffectShader(client.method_1531(), factory, framebuffer, shaderId);
                processor.setupDimensions(client.method_22683().method_4489(), client.method_22683().method_4506());
                POST_PROCESSOR_MAP.put(name, processor);
                Lazuli_Lib_Client.LOGGER.info("Post-processing shader '{}' registered in callback.", (Object)name);
            }
            catch (IOException e) {
                Lazuli_Lib_Client.LOGGER.error("Failed to load post-processing shader: {} <============================================================================================", (Object)name);
                Lazuli_Lib_Client.LOGGER.error("================================================[stack trace]================================================");
                e.printStackTrace();
                Lazuli_Lib_Client.LOGGER.error("================================================[  closing  ]================================================");
            }
        });
    }

    public static void register() {
        ClientTickEvents.START_CLIENT_TICK.register(t -> {
            class_1041 window = class_310.method_1551().method_22683();
            if (resX != window.method_4489() || resY != window.method_4506()) {
                LazuliShaderRegistry.windowResized(window.method_4506(), window.method_4489());
            }
            resX = window.method_4489();
            resY = window.method_4506();
        });
    }

    private static void windowResized(int height, int width) {
        for (Map.Entry<String, LazuliPostEffectShader> entry : POST_PROCESSOR_MAP.entrySet()) {
            LazuliPostEffectShader processor = entry.getValue();
            if (processor == null) continue;
            processor.setupDimensions(width, height);
        }
    }

    public static class_5944 getShader(String name) {
        return SHADER_MAP.get(name);
    }

    public static LazuliPostEffectShader getPostProcessor(String name) {
        return POST_PROCESSOR_MAP.get(name);
    }
}

