/*
 * Decompiled with CFR 0.152.
 */
package nishio.lazuli_lib.internals;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.IntSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_276;
import net.minecraft.class_280;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class LazuliPostEffectPass
implements AutoCloseable {
    private final class_280 program;
    public final class_276 input;
    public final class_276 output;
    private final List<IntSupplier> samplerValues = Lists.newArrayList();
    private final List<String> samplerNames = Lists.newArrayList();
    private final List<Integer> samplerWidths = Lists.newArrayList();
    private final List<Integer> samplerHeights = Lists.newArrayList();
    private Matrix4f projectionMatrix;
    private final int texFilter;

    public LazuliPostEffectPass(class_5912 resourceFactory, String programName, class_276 input, class_276 output, boolean linear) throws IOException {
        this.program = new class_280(resourceFactory, programName);
        this.input = input;
        this.output = output;
        this.texFilter = linear ? 9729 : 9728;
    }

    @Override
    public void close() {
        this.program.close();
    }

    public final String getName() {
        return this.program.method_35763();
    }

    public void addAuxTarget(String name, IntSupplier valueSupplier, int width, int height) {
        this.samplerNames.add(this.samplerNames.size(), name);
        this.samplerValues.add(this.samplerValues.size(), valueSupplier);
        this.samplerWidths.add(this.samplerWidths.size(), width);
        this.samplerHeights.add(this.samplerHeights.size(), height);
    }

    public void setProjectionMatrix(Matrix4f projectionMatrix) {
        this.projectionMatrix = projectionMatrix;
    }

    public void render(float time) {
        this.input.method_1240();
        float f = this.output.field_1482;
        float g = this.output.field_1481;
        RenderSystem.viewport((int)0, (int)0, (int)((int)f), (int)((int)g));
        class_280 shaderProgram = this.program;
        class_276 inputFrameBuffer = this.input;
        Objects.requireNonNull(inputFrameBuffer);
        shaderProgram.method_1269("DiffuseSampler", () -> ((class_276)inputFrameBuffer).method_30277());
        shaderProgram.method_1269("DepthSampler", () -> ((class_276)inputFrameBuffer).method_30278());
        for (int i = 0; i < this.samplerValues.size(); ++i) {
            this.program.method_1269(this.samplerNames.get(i), this.samplerValues.get(i));
            this.program.method_1275("AuxSize" + i).method_1255((float)this.samplerWidths.get(i).intValue(), (float)this.samplerHeights.get(i).intValue());
        }
        this.program.method_1275("ProjMat").method_1250(this.projectionMatrix);
        this.program.method_1275("InSize").method_1255((float)this.input.field_1482, (float)this.input.field_1481);
        this.program.method_1275("OutSize").method_1255(f, g);
        this.program.method_1275("Time").method_1251(time);
        class_310 minecraftClient = class_310.method_1551();
        this.program.method_1275("ScreenSize").method_1255((float)minecraftClient.method_22683().method_4489(), (float)minecraftClient.method_22683().method_4506());
        this.program.method_1277();
        this.output.method_1230(class_310.field_1703);
        this.output.method_1235(false);
        RenderSystem.depthFunc((int)519);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1592);
        bufferBuilder.method_22912(0.0f, 0.0f, 500.0f);
        bufferBuilder.method_22912(f, 0.0f, 500.0f);
        bufferBuilder.method_22912(f, g, 500.0f);
        bufferBuilder.method_22912(0.0f, g, 500.0f);
        class_286.method_43437((class_9801)bufferBuilder.method_60800());
        RenderSystem.depthFunc((int)515);
        this.program.method_1273();
        this.input.method_1242();
        for (IntSupplier object : this.samplerValues) {
            if (!(object instanceof class_276)) continue;
            ((class_276)object).method_1242();
        }
    }

    public class_280 getProgram() {
        return this.program;
    }

    public int getTexFilter() {
        return this.texFilter;
    }
}

