/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.globalization;

import io.gitlab.jfronny.globalization.Globalization;
import io.gitlab.jfronny.globalization.GlobalizationConfig;
import io.gitlab.jfronny.libjf.translate.api.Language;
import io.gitlab.jfronny.libjf.translate.api.TranslateException;
import io.gitlab.jfronny.libjf.translate.api.TranslateService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalizationMap
extends AbstractMap<String, String> {
    private static final Path targetPath = FabricLoader.getInstance().getConfigDir().resolve("globalization");
    private final List<Map<String, String>> pools = new LinkedList<Map<String, String>>();

    public void fork() {
        if (this.pools.isEmpty() || !this.getCurrentPool().isEmpty()) {
            this.pools.add(new LinkedHashMap());
        }
    }

    public Map<String, String> generateMissing() {
        if (this.pools.isEmpty()) {
            return Map.of();
        }
        if (this.pools.size() == 1) {
            return this.pools.getFirst();
        }
        return GlobalizationMap.generateMissing(this.pools.getLast(), this.pools.subList(0, this.pools.size() - 1), TranslateService.getConfigured());
    }

    private static <T extends Language, S extends TranslateService<T>> Map<String, String> generateMissing(Map<String, String> origin, List<Map<String, String>> other, S service) {
        Path cacheFile;
        Language targetLang;
        Properties cache;
        Map<String, String> toAdd;
        LinkedHashMap<String, String> target;
        block16: {
            target = new LinkedHashMap<String, String>(origin);
            toAdd = other.stream().map(Map::entrySet).flatMap(Collection::stream).filter(s -> !target.containsKey(s.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            cache = new Properties();
            targetLang = service.parseLang(GlobalizationConfig.targetCode);
            cacheFile = targetPath.resolve(targetLang.getIdentifier() + ".cache");
            try {
                Files.createDirectories(targetPath, new FileAttribute[0]);
                if (!Files.exists(cacheFile, new LinkOption[0])) break block16;
                try (BufferedReader r = Files.newBufferedReader(cacheFile);){
                    cache.load(r);
                }
            }
            catch (IOException e) {
                Globalization.LOG.error("Could not read cache", (Throwable)e);
            }
        }
        toAdd.forEach((k, v) -> {
            try {
                if (cache.containsKey(v)) {
                    target.put((String)k, cache.get(v).toString());
                } else {
                    String s = service.translate(v, service.detect(v), targetLang);
                    target.put((String)k, s);
                    cache.put(v, s);
                    Globalization.LOG.info("Translated " + v + " to " + s, new Object[0]);
                }
            }
            catch (TranslateException e) {
                Globalization.LOG.error("Could not translate " + v, (Throwable)e);
            }
        });
        try {
            Files.createDirectories(targetPath, new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(cacheFile, new OpenOption[0]);){
                cache.store(w, "Cache for translations to " + targetLang.getDisplayName());
            }
        }
        catch (IOException e) {
            Globalization.LOG.error("Could not write cache", (Throwable)e);
        }
        return target;
    }

    private Map<String, String> getCurrentPool() {
        if (this.pools.isEmpty()) {
            throw new IllegalStateException("Called method on non-forked globalization map");
        }
        return this.pools.getLast();
    }

    @Override
    @Nullable
    public String put(String s, String s2) {
        String s3 = this.getCurrentPool().put(s, s2);
        if (s3 == null) {
            for (Map<String, String> map : this.pools.subList(0, this.pools.size() - 1)) {
                s3 = map.getOrDefault(s, s3);
            }
        }
        return s3;
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, String>> entrySet() {
        return this.pools.stream().map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.toList())).entrySet().stream().map(s -> new Entry<String, String>((String)s.getKey(), (String)((Map.Entry)((List)s.getValue()).getLast()).getValue())).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return this.pools.stream().flatMap(s -> s.keySet().stream()).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public boolean isEmpty() {
        return this.pools.isEmpty() || this.pools.size() == 1 && this.pools.getFirst().isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.pools.stream().anyMatch(s -> s.containsKey(o));
    }

    @Override
    public boolean containsValue(Object o) {
        return this.pools.stream().anyMatch(s -> s.containsValue(o));
    }

    @Override
    public String get(Object o) {
        for (Map pool : this.pools.reversed()) {
            if (!pool.containsKey(o)) continue;
            return (String)pool.get(o);
        }
        return null;
    }

    @Override
    public String remove(Object o) {
        return this.pools.reversed().stream().map(s -> (String)s.remove(o)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public record Entry<K, V>(K key, V value) implements Map.Entry<K, V>
    {
        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }
}

