/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.components.index;

import com.google.common.collect.ImmutableList;
import fuzs.completionistsindex.client.gui.screens.index.IndexViewScreen;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3448;
import net.minecraft.class_3468;
import net.minecraft.class_3469;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9848;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class IndexViewEntry<S extends IndexViewScreen<?>> {
    protected static final List<class_3448<class_1792>> RELEVANT_STAT_TYPES = ImmutableList.of((Object)class_3468.field_15392, (Object)class_3468.field_15370);
    private static final class_2960 SLOT_HIGHLIGHT_BACK_SPRITE = class_2960.method_60656((String)"container/slot_highlight_back");
    private static final class_2960 SLOT_HIGHLIGHT_FRONT_SPRITE = class_2960.method_60656((String)"container/slot_highlight_front");
    protected final S screen;
    private final class_1799 itemStack;
    private final class_2561 displayName;
    private List<class_2561> tooltipLines;

    public IndexViewEntry(S screen, class_1799 itemStack, class_2561 displayName) {
        this.screen = screen;
        this.itemStack = itemStack;
        this.displayName = displayName;
    }

    @MustBeInvokedByOverriders
    public void initialize(class_3469 statsCounter) {
        this.tooltipLines = this.createTooltipLines(this.itemStack, statsCounter);
    }

    protected abstract List<class_2561> createTooltipLines(class_1799 var1, class_3469 var2);

    public abstract String toComparableKey();

    protected class_1792 getItem() {
        return this.itemStack.method_7909();
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameString() {
        return this.getDisplayName().getString();
    }

    protected class_2561 getStyledDisplayName() {
        return class_2561.method_43473().method_10852(this.getDisplayName()).method_27696(this.getTitleStyle());
    }

    private class_2583 getTitleStyle() {
        return this.isCollected() ? class_2583.field_24360.method_36139(class_9848.method_61334((int)4957487)) : class_2583.field_24360.method_10977(class_124.field_1074);
    }

    public abstract boolean isCollected();

    protected int getStatsValue(class_3469 statsCounter, class_1792 item) {
        return RELEVANT_STAT_TYPES.stream().mapToInt(statType -> statsCounter.method_15024(statType, (Object)item)).sum();
    }

    public final void renderWithTooltip(class_327 font, class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick, posX, posY);
        this.renderForeground(guiGraphics, mouseX, mouseY, partialTick, posX, posY, font);
        if (this.isHoveringSlot(posX, posY, mouseX, mouseY)) {
            guiGraphics.method_64038(font, this.tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean isHoveringSlot(int posX, int posY, int mouseX, int mouseY) {
        return this.isHovering(posX, posY, posX + 16, posY + 16, mouseX, mouseY);
    }

    public boolean isMouseOver(int posX, int posY, int mouseX, int mouseY) {
        return this.isHovering(posX, posY, posX + 134, posY + 18, mouseX, mouseY);
    }

    private boolean isHovering(int minX, int minY, int maxX, int maxY, int mouseX, int mouseY) {
        return mouseX > minX && mouseX <= maxX && mouseY > minY && mouseY <= maxY;
    }

    public abstract boolean mouseClicked(class_11909 var1);

    protected void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
        guiGraphics.method_25290(class_10799.field_56883, IndexViewScreen.INDEX_LOCATION, posX, posY, 120.0f, 208.0f, 18, 18, 512, 256);
        guiGraphics.method_25290(class_10799.field_56883, IndexViewScreen.INDEX_LOCATION, posX + 124, posY + 4, (float)(120 + (this.isCollected() ? 10 : 0)), 198.0f, 10, 10, 512, 256);
        if (this.isClickable() && this.isMouseOver(posX, posY, mouseX, mouseY)) {
            guiGraphics.method_25290(class_10799.field_56883, IndexViewScreen.INDEX_LOCATION, posX - 2, posY - 2, 316.0f, 0.0f, 140, 22, 512, 256);
        }
    }

    protected abstract boolean isClickable();

    protected void renderForeground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY, class_327 font) {
        if (this.isHoveringSlot(posX, posY, mouseX, mouseY)) {
            guiGraphics.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_BACK_SPRITE, posX + 1 - 4, posY + 1 - 4, 24, 24);
        }
        guiGraphics.method_51427(this.itemStack, posX + 1, posY + 1);
        if (this.isHoveringSlot(posX, posY, mouseX, mouseY)) {
            guiGraphics.method_52706(class_10799.field_56883, SLOT_HIGHLIGHT_FRONT_SPRITE, posX + 1 - 4, posY + 1 - 4, 24, 24);
        }
        class_2561 class_25612 = this.getStyledDisplayName();
        int n = posY + this.getDisplayNameYOffset();
        int n2 = posY + this.getDisplayNameYOffset();
        Objects.requireNonNull(font);
        IndexViewEntry.renderScrollingString(guiGraphics, font, class_25612, posX + 23, n, posX + 23 + 95, n2 + 9, class_9848.method_61334((int)0));
    }

    protected abstract int getDisplayNameYOffset();

    protected static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 text, int minX, int minY, int maxX, int maxY, int color) {
        IndexViewEntry.renderScrollingString(guiGraphics, font, text, (minX + maxX) / 2, minX, minY, maxX, maxY, color);
    }

    protected static void renderScrollingString(class_332 guiGraphics, class_327 font, class_2561 text, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        int i = font.method_27525((class_5348)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d = (double)class_156.method_658() / 1000.0;
            double e = Math.max((double)l * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = class_3532.method_16436((double)f, (double)0.0, (double)l);
            guiGraphics.method_44379(minX, minY, maxX, maxY);
            guiGraphics.method_51439(font, text, minX - (int)g, j, color, false);
            guiGraphics.method_44380();
        } else {
            int l = class_3532.method_15340((int)centerX, (int)(minX + i / 2), (int)(maxX - i / 2));
            class_5481 formattedCharSequence = text.method_30937();
            guiGraphics.method_51439(font, text, l - font.method_30880(formattedCharSequence) / 2, j, color, false);
        }
    }
}

