/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.components.index;

import com.google.common.collect.ImmutableList;
import fuzs.completionistsindex.client.gui.components.index.IndexViewEntry;
import fuzs.completionistsindex.client.gui.screens.index.IndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.index.ItemsIndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.index.ModsIndexViewScreen;
import fuzs.puzzleslib.api.client.gui.v2.GuiGraphicsHelper;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3469;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9848;

public class IndexViewGroupEntry
extends IndexViewEntry<ModsIndexViewScreen> {
    private static final DecimalFormat PERCENTAGE_FORMAT = new DecimalFormat("#.##");
    private final List<class_1799> items;
    private int collectedItems;

    public IndexViewGroupEntry(ModsIndexViewScreen screen, List<class_1799> items, class_2561 displayName) {
        super(screen, (class_1799)class_156.method_32309(items, (class_5819)IndexViewScreen.RANDOM), displayName);
        this.items = items;
    }

    @Override
    public void initialize(class_3469 statsCounter) {
        super.initialize(statsCounter);
        this.collectedItems = this.getCollectedItemsValue(statsCounter);
    }

    private int getCollectedItemsValue(class_3469 statsCounter) {
        return (int)this.items.stream().map(class_1799::method_7909).mapToInt(item -> this.getStatsValue(statsCounter, (class_1792)item)).filter(value -> value > 0).count();
    }

    @Override
    protected List<class_2561> createTooltipLines(class_1799 itemStack, class_3469 statsCounter) {
        float progressAmount = this.getProgressAmount(this.getCollectedItemsValue(statsCounter));
        class_5250 component = class_2561.method_43470((String)(" (" + PERCENTAGE_FORMAT.format(progressAmount * 100.0f) + "%)")).method_27692(class_124.field_1065);
        return ImmutableList.of((Object)class_2561.method_43473().method_10852(this.getDisplayName()).method_10852((class_2561)component));
    }

    private float getProgressAmount(int collectedItemsValue) {
        return (float)collectedItemsValue / (float)this.items.size();
    }

    private class_2561 getProgressComponent(int collectedItemsValue) {
        return class_2561.method_43470((String)(collectedItemsValue + "/" + this.items.size()));
    }

    @Override
    public String toComparableKey() {
        return this.getDisplayNameString();
    }

    @Override
    public boolean isCollected() {
        return this.collectedItems == this.items.size();
    }

    @Override
    public void renderBackground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick, posX, posY);
        guiGraphics.method_25290(class_10799.field_56883, IndexViewScreen.INDEX_LOCATION, posX + 24, posY + 11, 140.0f, 198.0f, 91, 5, 512, 256);
        guiGraphics.method_25290(class_10799.field_56883, IndexViewScreen.INDEX_LOCATION, posX + 24, posY + 11, 140.0f, 203.0f, (int)(91.0f * this.getProgressAmount(this.collectedItems)), 5, 512, 256);
    }

    @Override
    protected boolean isClickable() {
        return true;
    }

    @Override
    public void renderForeground(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY, class_327 font) {
        super.renderForeground(guiGraphics, mouseX, mouseY, partialTick, posX, posY, font);
        class_2561 progressComponent = this.getProgressComponent(this.collectedItems);
        GuiGraphicsHelper.drawInBatch8xOutline((class_332)guiGraphics, (class_327)font, (class_2561)progressComponent, (int)(posX + 70 - font.method_27525((class_5348)progressComponent) / 2), (int)(posY + 10), (int)class_9848.method_61334((int)16762624), (int)class_9848.method_61334((int)0));
    }

    @Override
    protected int getDisplayNameYOffset() {
        return 0;
    }

    @Override
    public boolean mouseClicked(class_11909 mouseButtonEvent) {
        ((ModsIndexViewScreen)this.screen).field_22787.method_1507((class_437)new ItemsIndexViewScreen((class_437)this.screen, ((ModsIndexViewScreen)this.screen).isFromInventory(), this.items));
        ((ModsIndexViewScreen)this.screen).field_22787.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        return true;
    }
}

