/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.components.index.IndexViewEntry;
import fuzs.completionistsindex.client.gui.screens.index.SortProvider;
import fuzs.completionistsindex.config.ClientConfig;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SequencedMap;
import java.util.stream.Collectors;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public enum IndexGroup implements SortProvider<IndexGroup>
{
    CREATIVE{

        @Override
        public Comparator<IndexViewEntry<?>> getComparator() {
            return (arg_0, arg_1) -> ((Ordering)Ordering.allEqual()).compare(arg_0, arg_1);
        }

        @Override
        SequencedMap<class_2561, List<class_1799>> getGroups() {
            LinkedHashMap<class_2561, List<class_1799>> groups = new LinkedHashMap<class_2561, List<class_1799>>();
            for (class_1761 creativeModeTab : class_7923.field_44687.method_10220().toList()) {
                List<class_1799> items;
                if (creativeModeTab.method_47312() != class_1761.class_7916.field_41052 || ((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class)).hiddenCreativeTabs.contains((Object)creativeModeTab) || (items = this.getDisplayItems(creativeModeTab)).isEmpty()) continue;
                groups.put(creativeModeTab.method_7737(), items);
            }
            return groups;
        }
    }
    ,
    MODS{

        @Override
        public Comparator<IndexViewEntry<?>> getComparator() {
            return Comparator.comparing(IndexViewEntry::toComparableKey);
        }

        @Override
        SequencedMap<class_2561, List<class_1799>> getGroups() {
            return this.getAllItems().stream().collect(Collectors.groupingBy(itemStack -> {
                String modId = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).method_12836();
                return class_2561.method_43470((String)ModContainer.getDisplayName((String)modId));
            }, LinkedHashMap::new, Collectors.toList()));
        }
    };

    private static final IndexGroup[] VALUES;
    private final class_2561 component = class_2561.method_43471((String)("completionistsindex.gui.index.group." + this.name().toLowerCase(Locale.ROOT)));

    @Override
    public IndexGroup cycle() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    @Override
    public class_2561 getComponent() {
        return this.component;
    }

    abstract SequencedMap<class_2561, List<class_1799>> getGroups();

    public final Map<class_2561, List<class_1799>> getDisplayGroups() {
        SequencedMap<class_2561, List<class_1799>> groups = this.getGroups();
        if (groups.size() > 1) {
            groups.putFirst((class_2561)class_2561.method_43471((String)"gui.all"), this.getAllItems());
        }
        return ImmutableMap.copyOf(groups);
    }

    List<class_1799> getAllItems() {
        return this.getDisplayItems(class_7706.method_47344());
    }

    List<class_1799> getDisplayItems(class_1761 creativeModeTab) {
        return creativeModeTab.method_47313().stream().map(class_1799::method_7909).distinct().filter(((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class))::filterItems).map(class_1799::new).toList();
    }

    static {
        VALUES = IndexGroup.values();
    }
}

