/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.index;

import com.google.common.collect.ImmutableList;
import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.components.index.IndexViewEntry;
import fuzs.completionistsindex.client.gui.screens.index.SortProvider;
import fuzs.completionistsindex.client.gui.screens.index.StatsUpdateListener;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5819;
import net.minecraft.class_7919;
import net.minecraft.class_8027;
import net.minecraft.class_8030;
import org.jetbrains.annotations.Nullable;

public abstract class IndexViewScreen<T extends SortProvider<T>>
extends StatsUpdateListener {
    public static final class_2960 INDEX_LOCATION = CompletionistsIndex.id("textures/gui/index.png");
    private static final class_2561 PREVIOUS_PAGE_COMPONENT = class_2561.method_43471((String)"spectatorMenu.previous_page");
    private static final class_2561 NEXT_PAGE_COMPONENT = class_2561.method_43471((String)"spectatorMenu.next_page");
    private static final class_2561 SEARCH_HINT = class_2561.method_43471((String)"gui.recipebook.search_hint").method_27692(class_124.field_1056).method_27692(class_124.field_1080);
    public static final class_5819 RANDOM = class_5819.method_43047();
    private final boolean fromInventory;
    protected int imageWidth = 316;
    protected int imageHeight = 198;
    protected int leftPos;
    protected int topPos;
    private class_4185 turnPageBackwards;
    private class_4185 turnPageForwards;
    private int currentPage;
    private class_2561 leftPageIndicator;
    private class_2561 rightPageIndicator;
    private List<IndexViewPage> pages;
    @Nullable
    private class_342 searchBox;
    private String lastSearch = "";
    private boolean ignoreTextInput;
    @Nullable
    private class_8030 magnifierIconPlacement;
    private long randomSeed;

    protected IndexViewScreen(@Nullable class_437 lastScreen, boolean fromInventory) {
        super(lastScreen);
        this.fromInventory = fromInventory;
    }

    protected abstract Stream<IndexViewEntry<?>> getPageEntries();

    protected void rebuildPages() {
        RANDOM.method_43052(this.randomSeed);
        List<IndexViewEntry<?>> entries = this.getPageEntries().filter(entry -> entry.getDisplayNameString().toLowerCase(Locale.ROOT).contains(this.getSearchQuery())).sorted(this.getSortProvider().getComparator()).toList();
        this.pages = IndexViewPage.createPages(this, entries);
        this.setCurrentPage(0);
    }

    @Override
    protected void method_25426() {
        this.leftPos = (this.field_22789 - this.imageWidth) / 2;
        this.topPos = (this.field_22790 - this.imageHeight + 23) / 2;
        this.randomSeed = RANDOM.method_43055();
        this.magnifierIconPlacement = class_8030.method_48250((class_8027)class_8027.field_41822, (int)(this.leftPos + (this.imageWidth / 2 - 146) / 2 + 18), (int)(this.topPos - 23 + 5), (int)16, (int)16);
        int n = this.leftPos + (this.imageWidth / 2 - 146) / 2 + 43;
        Objects.requireNonNull(this.field_22793);
        this.searchBox = new class_342(this.field_22793, n, this.topPos - 23 + 6, 81, 9 + 5, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(-1);
        this.searchBox.method_47404(SEARCH_HINT);
        this.method_37063((class_364)new SpritelessImageButton(this.leftPos + this.imageWidth - 6 - 26 + 5, this.topPos - 23 + 5, 16, 16, this.imageWidth + 5, 50, 23, INDEX_LOCATION, 512, 256, button -> this.method_25419()));
        ((SpritelessImageButton)this.method_37063((class_364)new SpritelessImageButton(this.leftPos + this.imageWidth - 17 - 16, this.topPos + 11, 16, 13, 62, 202, 20, INDEX_LOCATION, 512, 256, button -> {
            this.setSortProvider((SortProvider)this.getSortProvider().cycle());
            button.method_47400(class_7919.method_47407((class_2561)this.getSortProvider().getComponent()));
            this.rebuildPages();
        }))).method_47400(class_7919.method_47407((class_2561)this.getSortProvider().getComponent()));
        this.turnPageBackwards = (class_4185)this.method_37063((class_364)new SpritelessImageButton(this.leftPos + 27, this.topPos + 173, 18, 10, 1, 203, 20, INDEX_LOCATION, 512, 256, button -> this.decrementPage()));
        this.turnPageBackwards.method_47400(class_7919.method_47407((class_2561)PREVIOUS_PAGE_COMPONENT));
        this.turnPageForwards = (class_4185)this.method_37063((class_364)new SpritelessImageButton(this.leftPos + this.imageWidth - 27 - 18, this.topPos + 173, 18, 10, 21, 203, 20, INDEX_LOCATION, 512, 256, button -> this.incrementPage()));
        this.turnPageForwards.method_47400(class_7919.method_47407((class_2561)NEXT_PAGE_COMPONENT));
        this.setCurrentPage(this.currentPage);
        this.resetLastSearch();
    }

    public boolean isFromInventory() {
        return this.fromInventory;
    }

    private void resetLastSearch() {
        this.lastSearch = "";
    }

    protected abstract T getSortProvider();

    protected abstract void setSortProvider(T var1);

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.fromInventory) {
            this.method_52752(guiGraphics);
        } else {
            super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
        }
        guiGraphics.method_25290(class_10799.field_56883, INDEX_LOCATION, this.leftPos + (this.imageWidth / 2 - 146) / 2, this.topPos - 23, (float)this.imageWidth, 22.0f, 146, 23, 512, 256);
        guiGraphics.method_25290(class_10799.field_56883, INDEX_LOCATION, this.leftPos + this.imageWidth - 6 - 26, this.topPos - 23, (float)this.imageWidth, 45.0f, 26, 23, 512, 256);
        guiGraphics.method_25290(class_10799.field_56883, INDEX_LOCATION, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
        guiGraphics.method_51439(this.field_22793, this.leftPageIndicator, this.leftPos + 82 - this.field_22793.method_27525((class_5348)this.leftPageIndicator) / 2, this.topPos + 13, -4676470, false);
        guiGraphics.method_51439(this.field_22793, this.rightPageIndicator, this.leftPos + 233 - this.field_22793.method_27525((class_5348)this.rightPageIndicator) / 2, this.topPos + 13, -4676470, false);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25395(null);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.searchBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.pages != null && !this.pages.isEmpty()) {
            this.pages.get(this.currentPage).method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        boolean mouseClickedOnMagnifier;
        this.searchBox.method_25365(false);
        if (super.method_25402(mouseButtonEvent, doubleClick)) {
            return true;
        }
        if (this.pages != null && !this.pages.isEmpty() && this.pages.get(this.currentPage).mouseClicked(mouseButtonEvent)) {
            return true;
        }
        boolean bl = mouseClickedOnMagnifier = this.magnifierIconPlacement != null && this.magnifierIconPlacement.method_58137(class_3532.method_15357((double)mouseButtonEvent.comp_4798()), class_3532.method_15357((double)mouseButtonEvent.comp_4799()));
        if (mouseClickedOnMagnifier || this.searchBox.method_25402(mouseButtonEvent, doubleClick)) {
            this.searchBox.method_25365(true);
            return true;
        }
        return false;
    }

    private void decrementPage() {
        if (this.currentPage > 0) {
            this.setCurrentPage(this.currentPage - 1);
        }
    }

    private void incrementPage() {
        if (this.currentPage < this.getAllPages() - 1) {
            this.setCurrentPage(this.currentPage + 1);
        }
    }

    private void setCurrentPage(int newPage) {
        this.currentPage = newPage;
        this.turnPageForwards.field_22764 = true;
        this.turnPageBackwards.field_22764 = true;
        if (newPage == 0) {
            this.turnPageBackwards.field_22764 = false;
        }
        if (newPage >= this.getAllPages() - 1) {
            this.turnPageForwards.field_22764 = false;
        }
        this.leftPageIndicator = class_2561.method_43469((String)"book.pageIndicator", (Object[])new Object[]{newPage * 2 + 1, this.getAllPages() * 2});
        this.rightPageIndicator = class_2561.method_43469((String)"book.pageIndicator", (Object[])new Object[]{newPage * 2 + 2, this.getAllPages() * 2});
    }

    private int getAllPages() {
        return this.pages != null && !this.pages.isEmpty() ? this.pages.size() : 1;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollX > 0.0 || scrollY > 0.0) {
            this.decrementPage();
            return true;
        }
        if (scrollX < 0.0 || scrollY < 0.0) {
            this.incrementPage();
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean method_25404(class_11908 keyEvent) {
        this.ignoreTextInput = false;
        if (this.searchBox.method_25404(keyEvent)) {
            this.checkSearchStringUpdate();
            return true;
        }
        if (this.field_22787.field_1690.field_1890.method_1417(keyEvent) && !this.searchBox.method_25370()) {
            this.ignoreTextInput = true;
            this.searchBox.method_25365(true);
            return true;
        }
        return super.method_25404(keyEvent);
    }

    public boolean method_16803(class_11908 keyEvent) {
        this.ignoreTextInput = false;
        return super.method_16803(keyEvent);
    }

    public boolean method_25400(class_11905 characterEvent) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (this.searchBox.method_25400(characterEvent)) {
            this.checkSearchStringUpdate();
            return true;
        }
        return super.method_25400(characterEvent);
    }

    private String getSearchQuery() {
        return this.searchBox != null ? this.searchBox.method_1882().trim().toLowerCase(Locale.ROOT) : "";
    }

    private void checkSearchStringUpdate() {
        String string = this.getSearchQuery();
        if (!string.equals(this.lastSearch)) {
            this.rebuildPages();
            this.lastSearch = string;
        }
    }

    protected static class IndexViewPage
    implements class_4068 {
        private final IndexViewEntry<?>[] entries = new IndexViewEntry[14];
        private final IndexViewScreen<?> screen;

        private IndexViewPage(IndexViewScreen<?> screen) {
            this.screen = screen;
        }

        public static List<IndexViewPage> createPages(IndexViewScreen<?> screen, List<IndexViewEntry<?>> entries) {
            ImmutableList.Builder builder = ImmutableList.builder();
            IndexViewPage page = null;
            int itemsCount = 0;
            for (IndexViewEntry<?> entry : entries) {
                if (page == null) {
                    page = new IndexViewPage(screen);
                    builder.add((Object)page);
                }
                page.entries[itemsCount] = entry;
                if (++itemsCount < 14) continue;
                itemsCount = 0;
                page = null;
            }
            return builder.build();
        }

        public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderPageSide(guiGraphics, mouseX, mouseY, partialTick, this.screen.leftPos + 16, this.screen.topPos + 26, 0, 7);
            this.renderPageSide(guiGraphics, mouseX, mouseY, partialTick, this.screen.leftPos + 167, this.screen.topPos + 26, 7, 14);
        }

        private void renderPageSide(class_332 guiGraphics, int mouseX, int mouseY, float partialTick, int startX, int startY, int startIndex, int endIndex) {
            IndexViewEntry<?> indexViewEntry;
            int posY = startY;
            for (int i = startIndex; i < endIndex && (indexViewEntry = this.entries[i]) != null; ++i) {
                indexViewEntry.renderWithTooltip(((IndexViewScreen)this.screen).field_22793, guiGraphics, mouseX, mouseY, partialTick, startX, posY);
                posY += 21;
            }
        }

        public boolean mouseClicked(class_11909 mouseButtonEvent) {
            for (int i = 0; i < this.entries.length; ++i) {
                IndexViewEntry<?> indexViewEntry = this.entries[i];
                if (indexViewEntry != null) {
                    int posY;
                    int posX = i >= 7 ? this.screen.leftPos + 167 : this.screen.leftPos + 16;
                    if (!indexViewEntry.isMouseOver(posX, posY = this.screen.topPos + 26 + i % 7 * 21, class_3532.method_15357((double)mouseButtonEvent.comp_4798()), class_3532.method_15357((double)mouseButtonEvent.comp_4799()))) continue;
                    return indexViewEntry.mouseClicked(mouseButtonEvent);
                }
                return false;
            }
            return false;
        }
    }
}

