/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.components.index;

import com.google.common.collect.ImmutableList;
import fuzs.completionistsindex.client.gui.screens.index.IndexViewScreen;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

public abstract class IndexViewEntry<S extends IndexViewScreen<?>> {
    protected static final List<StatType<Item>> RELEVANT_STAT_TYPES = ImmutableList.of((Object)Stats.ITEM_PICKED_UP, (Object)Stats.ITEM_CRAFTED);
    private static final ResourceLocation SLOT_HIGHLIGHT_BACK_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_back");
    private static final ResourceLocation SLOT_HIGHLIGHT_FRONT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_front");
    protected final S screen;
    private final ItemStack itemStack;
    private final Component displayName;
    private List<Component> tooltipLines;

    public IndexViewEntry(S screen, ItemStack itemStack, Component displayName) {
        this.screen = screen;
        this.itemStack = itemStack;
        this.displayName = displayName;
    }

    @MustBeInvokedByOverriders
    public void initialize(StatsCounter statsCounter) {
        this.tooltipLines = this.createTooltipLines(this.itemStack, statsCounter);
    }

    protected abstract List<Component> createTooltipLines(ItemStack var1, StatsCounter var2);

    public abstract String toComparableKey();

    protected Item getItem() {
        return this.itemStack.getItem();
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public String getDisplayNameString() {
        return this.getDisplayName().getString();
    }

    protected Component getStyledDisplayName() {
        return Component.empty().append(this.getDisplayName()).withStyle(this.getTitleStyle());
    }

    private Style getTitleStyle() {
        return this.isCollected() ? Style.EMPTY.withColor(ARGB.opaque((int)4957487)) : Style.EMPTY.withColor(ChatFormatting.BLACK);
    }

    public abstract boolean isCollected();

    protected int getStatsValue(StatsCounter statsCounter, Item item) {
        return RELEVANT_STAT_TYPES.stream().mapToInt(statType -> statsCounter.getValue(statType, (Object)item)).sum();
    }

    public final void renderWithTooltip(Font font, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick, posX, posY);
        this.renderForeground(guiGraphics, mouseX, mouseY, partialTick, posX, posY, font);
        if (this.isHoveringSlot(posX, posY, mouseX, mouseY)) {
            guiGraphics.setTooltipForNextFrame(font, this.tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean isHoveringSlot(int posX, int posY, int mouseX, int mouseY) {
        return this.isHovering(posX, posY, posX + 16, posY + 16, mouseX, mouseY);
    }

    public boolean isMouseOver(int posX, int posY, int mouseX, int mouseY) {
        return this.isHovering(posX, posY, posX + 134, posY + 18, mouseX, mouseY);
    }

    private boolean isHovering(int minX, int minY, int maxX, int maxY, int mouseX, int mouseY) {
        return mouseX > minX && mouseX <= maxX && mouseY > minY && mouseY <= maxY;
    }

    public abstract boolean mouseClicked(MouseButtonEvent var1);

    protected void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, IndexViewScreen.INDEX_LOCATION, posX, posY, 120.0f, 208.0f, 18, 18, 512, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, IndexViewScreen.INDEX_LOCATION, posX + 124, posY + 4, (float)(120 + (this.isCollected() ? 10 : 0)), 198.0f, 10, 10, 512, 256);
        if (this.isClickable() && this.isMouseOver(posX, posY, mouseX, mouseY)) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, IndexViewScreen.INDEX_LOCATION, posX - 2, posY - 2, 316.0f, 0.0f, 140, 22, 512, 256);
        }
    }

    protected abstract boolean isClickable();

    protected void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY, Font font) {
        if (this.isHoveringSlot(posX, posY, mouseX, mouseY)) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK_SPRITE, posX + 1 - 4, posY + 1 - 4, 24, 24);
        }
        guiGraphics.renderItem(this.itemStack, posX + 1, posY + 1);
        if (this.isHoveringSlot(posX, posY, mouseX, mouseY)) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_FRONT_SPRITE, posX + 1 - 4, posY + 1 - 4, 24, 24);
        }
        Component component = this.getStyledDisplayName();
        int n = posY + this.getDisplayNameYOffset();
        int n2 = posY + this.getDisplayNameYOffset();
        Objects.requireNonNull(font);
        IndexViewEntry.renderScrollingString(guiGraphics, font, component, posX + 23, n, posX + 23 + 95, n2 + 9, ARGB.opaque((int)0));
    }

    protected abstract int getDisplayNameYOffset();

    protected static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int minX, int minY, int maxX, int maxY, int color) {
        IndexViewEntry.renderScrollingString(guiGraphics, font, text, (minX + maxX) / 2, minX, minY, maxX, maxY, color);
    }

    protected static void renderScrollingString(GuiGraphics guiGraphics, Font font, Component text, int centerX, int minX, int minY, int maxX, int maxY, int color) {
        int i = font.width((FormattedText)text);
        int j = (minY + maxY - 9) / 2 + 1;
        int k = maxX - minX;
        if (i > k) {
            int l = i - k;
            double d = (double)Util.getMillis() / 1000.0;
            double e = Math.max((double)l * 0.5, 3.0);
            double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
            double g = Mth.lerp((double)f, (double)0.0, (double)l);
            guiGraphics.enableScissor(minX, minY, maxX, maxY);
            guiGraphics.drawString(font, text, minX - (int)g, j, color, false);
            guiGraphics.disableScissor();
        } else {
            int l = Mth.clamp((int)centerX, (int)(minX + i / 2), (int)(maxX - i / 2));
            FormattedCharSequence formattedCharSequence = text.getVisualOrderText();
            guiGraphics.drawString(font, text, l - font.width(formattedCharSequence) / 2, j, color, false);
        }
    }
}

