/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.components.index;

import com.google.common.collect.ImmutableList;
import fuzs.completionistsindex.client.gui.components.index.IndexViewEntry;
import fuzs.completionistsindex.client.gui.screens.index.IndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.index.ItemsIndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.index.ModsIndexViewScreen;
import fuzs.puzzleslib.api.client.gui.v2.GuiGraphicsHelper;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class IndexViewGroupEntry
extends IndexViewEntry<ModsIndexViewScreen> {
    private static final DecimalFormat PERCENTAGE_FORMAT = new DecimalFormat("#.##");
    private final List<ItemStack> items;
    private int collectedItems;

    public IndexViewGroupEntry(ModsIndexViewScreen screen, List<ItemStack> items, Component displayName) {
        super(screen, (ItemStack)Util.getRandom(items, (RandomSource)IndexViewScreen.RANDOM), displayName);
        this.items = items;
    }

    @Override
    public void initialize(StatsCounter statsCounter) {
        super.initialize(statsCounter);
        this.collectedItems = this.getCollectedItemsValue(statsCounter);
    }

    private int getCollectedItemsValue(StatsCounter statsCounter) {
        return (int)this.items.stream().map(ItemStack::getItem).mapToInt(item -> this.getStatsValue(statsCounter, (Item)item)).filter(value -> value > 0).count();
    }

    @Override
    protected List<Component> createTooltipLines(ItemStack itemStack, StatsCounter statsCounter) {
        float progressAmount = this.getProgressAmount(this.getCollectedItemsValue(statsCounter));
        MutableComponent component = Component.literal((String)(" (" + PERCENTAGE_FORMAT.format(progressAmount * 100.0f) + "%)")).withStyle(ChatFormatting.GOLD);
        return ImmutableList.of((Object)Component.empty().append(this.getDisplayName()).append((Component)component));
    }

    private float getProgressAmount(int collectedItemsValue) {
        return (float)collectedItemsValue / (float)this.items.size();
    }

    private Component getProgressComponent(int collectedItemsValue) {
        return Component.literal((String)(collectedItemsValue + "/" + this.items.size()));
    }

    @Override
    public String toComparableKey() {
        return this.getDisplayNameString();
    }

    @Override
    public boolean isCollected() {
        return this.collectedItems == this.items.size();
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick, posX, posY);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, IndexViewScreen.INDEX_LOCATION, posX + 24, posY + 11, 140.0f, 198.0f, 91, 5, 512, 256);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, IndexViewScreen.INDEX_LOCATION, posX + 24, posY + 11, 140.0f, 203.0f, (int)(91.0f * this.getProgressAmount(this.collectedItems)), 5, 512, 256);
    }

    @Override
    protected boolean isClickable() {
        return true;
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, int posX, int posY, Font font) {
        super.renderForeground(guiGraphics, mouseX, mouseY, partialTick, posX, posY, font);
        Component progressComponent = this.getProgressComponent(this.collectedItems);
        GuiGraphicsHelper.drawInBatch8xOutline((GuiGraphics)guiGraphics, (Font)font, (Component)progressComponent, (int)(posX + 70 - font.width((FormattedText)progressComponent) / 2), (int)(posY + 10), (int)ARGB.opaque((int)16762624), (int)ARGB.opaque((int)0));
    }

    @Override
    protected int getDisplayNameYOffset() {
        return 0;
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent) {
        ((ModsIndexViewScreen)this.screen).minecraft.setScreen((Screen)new ItemsIndexViewScreen((Screen)this.screen, ((ModsIndexViewScreen)this.screen).isFromInventory(), this.items));
        ((ModsIndexViewScreen)this.screen).minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        return true;
    }
}

