/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.components.index;

import com.google.common.collect.ImmutableList;
import fuzs.completionistsindex.client.gui.components.index.IndexViewEntry;
import fuzs.completionistsindex.client.gui.screens.index.ItemsIndexViewScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class IndexViewSingleEntry
extends IndexViewEntry<ItemsIndexViewScreen> {
    private boolean isCollected;

    public IndexViewSingleEntry(ItemsIndexViewScreen screen, ItemStack itemStack) {
        super(screen, itemStack, itemStack.getItemName());
    }

    @Override
    public void initialize(StatsCounter statsCounter) {
        super.initialize(statsCounter);
        this.isCollected = this.getStatsValue(statsCounter, this.getItem()) > 0;
    }

    @Override
    protected List<Component> createTooltipLines(ItemStack itemStack, StatsCounter statsCounter) {
        ArrayList<Object> tooltipLines = new ArrayList<Object>();
        tooltipLines.add(itemStack.getStyledHoverName());
        for (StatType statType : RELEVANT_STAT_TYPES) {
            Component component = statType.getDisplayName();
            int value = statsCounter.getValue(statType, (Object)this.getItem());
            if (value <= 0) continue;
            tooltipLines.add(Component.literal((String)String.valueOf(value)).append(CommonComponents.SPACE).append(component).withStyle(ChatFormatting.BLUE));
        }
        return ImmutableList.copyOf(tooltipLines);
    }

    @Override
    public String toComparableKey() {
        return BuiltInRegistries.ITEM.getKey((Object)this.getItem()).getPath();
    }

    @Override
    public boolean isCollected() {
        return this.isCollected;
    }

    @Override
    protected boolean isClickable() {
        return ((ItemsIndexViewScreen)this.screen).getServerPlayer() != null;
    }

    @Override
    protected int getDisplayNameYOffset() {
        return 4;
    }

    @Override
    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent) {
        ServerPlayer serverPlayer = ((ItemsIndexViewScreen)this.screen).getServerPlayer();
        if (serverPlayer != null) {
            Item item;
            ServerStatsCounter statsCounter = serverPlayer.getStats();
            if (this.getStatsValue((StatsCounter)statsCounter, item = this.getItem()) > 0) {
                for (StatType statType : RELEVANT_STAT_TYPES) {
                    serverPlayer.resetStat(statType.get((Object)item));
                }
            } else {
                serverPlayer.awardStat(((StatType)RELEVANT_STAT_TYPES.getFirst()).get((Object)item));
            }
            this.initialize((StatsCounter)statsCounter);
            ((ItemsIndexViewScreen)this.screen).minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return false;
    }
}

