/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import fuzs.completionistsindex.CompletionistsIndex;
import fuzs.completionistsindex.client.gui.components.index.IndexViewEntry;
import fuzs.completionistsindex.client.gui.screens.index.SortProvider;
import fuzs.completionistsindex.config.ClientConfig;
import fuzs.puzzleslib.api.core.v1.ModContainer;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SequencedMap;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;

public enum IndexGroup implements SortProvider<IndexGroup>
{
    CREATIVE{

        @Override
        public Comparator<IndexViewEntry<?>> getComparator() {
            return (arg_0, arg_1) -> ((Ordering)Ordering.allEqual()).compare(arg_0, arg_1);
        }

        @Override
        SequencedMap<Component, List<ItemStack>> getGroups() {
            LinkedHashMap<Component, List<ItemStack>> groups = new LinkedHashMap<Component, List<ItemStack>>();
            for (CreativeModeTab creativeModeTab : BuiltInRegistries.CREATIVE_MODE_TAB.stream().toList()) {
                List<ItemStack> items;
                if (creativeModeTab.getType() != CreativeModeTab.Type.CATEGORY || ((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class)).hiddenCreativeTabs.contains((Object)creativeModeTab) || (items = this.getDisplayItems(creativeModeTab)).isEmpty()) continue;
                groups.put(creativeModeTab.getDisplayName(), items);
            }
            return groups;
        }
    }
    ,
    MODS{

        @Override
        public Comparator<IndexViewEntry<?>> getComparator() {
            return Comparator.comparing(IndexViewEntry::toComparableKey);
        }

        @Override
        SequencedMap<Component, List<ItemStack>> getGroups() {
            return this.getAllItems().stream().collect(Collectors.groupingBy(itemStack -> {
                String modId = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).getNamespace();
                return Component.literal((String)ModContainer.getDisplayName((String)modId));
            }, LinkedHashMap::new, Collectors.toList()));
        }
    };

    private static final IndexGroup[] VALUES;
    private final Component component = Component.translatable((String)("completionistsindex.gui.index.group." + this.name().toLowerCase(Locale.ROOT)));

    @Override
    public IndexGroup cycle() {
        return VALUES[(this.ordinal() + 1) % VALUES.length];
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    abstract SequencedMap<Component, List<ItemStack>> getGroups();

    public final Map<Component, List<ItemStack>> getDisplayGroups() {
        SequencedMap<Component, List<ItemStack>> groups = this.getGroups();
        if (groups.size() > 1) {
            groups.putFirst((Component)Component.translatable((String)"gui.all"), this.getAllItems());
        }
        return ImmutableMap.copyOf(groups);
    }

    List<ItemStack> getAllItems() {
        return this.getDisplayItems(CreativeModeTabs.searchTab());
    }

    List<ItemStack> getDisplayItems(CreativeModeTab creativeModeTab) {
        return creativeModeTab.getDisplayItems().stream().map(ItemStack::getItem).distinct().filter(((ClientConfig)CompletionistsIndex.CONFIG.get(ClientConfig.class))::filterItems).map(ItemStack::new).toList();
    }

    static {
        VALUES = IndexGroup.values();
    }
}

