/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.client.gui.screens.index;

import fuzs.completionistsindex.client.gui.components.index.IndexViewEntry;
import fuzs.completionistsindex.client.gui.components.index.IndexViewSingleEntry;
import fuzs.completionistsindex.client.gui.screens.index.IndexViewScreen;
import fuzs.completionistsindex.client.gui.screens.index.StatsSorting;
import fuzs.puzzleslib.api.client.gui.v2.components.SpritelessImageButton;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatsCounter;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemsIndexViewScreen
extends IndexViewScreen<StatsSorting> {
    private static StatsSorting statsSorting = StatsSorting.COLLECTED;
    private final List<ItemStack> items;
    @Nullable
    private final ServerPlayer serverPlayer;
    private boolean isEditingPermitted;

    public ItemsIndexViewScreen(Screen lastScreen, boolean fromInventory, List<ItemStack> items) {
        super(lastScreen, fromInventory);
        this.items = items;
        this.serverPlayer = this.getPlayerFromServer();
    }

    @Nullable
    private ServerPlayer getPlayerFromServer() {
        ServerPlayer serverPlayer;
        IntegratedServer integratedServer = Minecraft.getInstance().getSingleplayerServer();
        if (integratedServer != null && (serverPlayer = integratedServer.getPlayerList().getPlayer(integratedServer.getSingleplayerProfile().id())) != null && serverPlayer.canUseGameMasterBlocks()) {
            return serverPlayer;
        }
        return null;
    }

    @Nullable
    public ServerPlayer getServerPlayer() {
        return this.isEditingPermitted ? this.serverPlayer : null;
    }

    @Override
    protected Stream<IndexViewEntry<?>> getPageEntries() {
        StatsCounter statsCounter = this.minecraft.player.getStats();
        return this.items.stream().map(itemStack -> {
            IndexViewSingleEntry indexViewEntry = new IndexViewSingleEntry(this, (ItemStack)itemStack);
            indexViewEntry.initialize(statsCounter);
            return indexViewEntry;
        });
    }

    @Override
    protected void init() {
        super.init();
        ((SpritelessImageButton)this.addRenderableWidget((GuiEventListener)new SpritelessImageButton(this.leftPos + 17, this.topPos + 11, 16, 13, 42, 202, 20, INDEX_LOCATION, 512, 256, button -> this.minecraft.setScreen(this.lastScreen)))).setTooltip(Tooltip.create((Component)CommonComponents.GUI_BACK));
        if (this.serverPlayer != null) {
            this.addRenderableWidget((GuiEventListener)new SpritelessImageButton(this.leftPos + 316 - 6 - 52 + 5 - 3, this.topPos - 23 + 5, 16, 16, this.isEditingPermitted ? 373 : 347, 50, 23, INDEX_LOCATION, 512, 256, button -> {
                this.isEditingPermitted = !this.isEditingPermitted;
                ((SpritelessImageButton)button).xTexStart = this.isEditingPermitted ? 373 : 347;
            }));
        }
        this.rebuildPages();
    }

    @Override
    protected StatsSorting getSortProvider() {
        return statsSorting;
    }

    @Override
    protected void setSortProvider(StatsSorting sortProvider) {
        statsSorting = sortProvider;
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        if (this.serverPlayer != null) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, INDEX_LOCATION, this.leftPos + 316 - 6 - 52 - 3, this.topPos - 23, this.isEditingPermitted ? 368.0f : 342.0f, 45.0f, 26, 23, 512, 256);
        }
    }

    @Override
    public boolean keyPressed(KeyEvent keyEvent) {
        if (super.keyPressed(keyEvent)) {
            return true;
        }
        if (keyEvent.input() == 259 && this.shouldCloseOnEsc()) {
            this.minecraft.setScreen(this.lastScreen);
            return true;
        }
        return false;
    }

    public void onClose() {
        if (this.lastScreen != null) {
            this.lastScreen.onClose();
        }
    }
}

