/*
 * Decompiled with CFR 0.152.
 */
package fuzs.completionistsindex.config;

import fuzs.puzzleslib.api.config.v3.Config;
import fuzs.puzzleslib.api.config.v3.ConfigCore;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.api.config.v3.serialization.KeyedValueProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class ClientConfig
implements ConfigCore {
    @Config(description={"Choose which screens to add the Completionist's Index button to."})
    public IndexButtonScreen indexButtonScreen = IndexButtonScreen.PAUSE_MENU;
    @Config(name="indexed_items", description={"A list for overriding all items in the index, no other items are included."})
    List<String> indexedItemsRaw = KeyedValueProvider.tagAppender((ResourceKey)Registries.ITEM).asStringList();
    @Config(name="unobtainable_items", description={"Add items to this list that should be excluded from the index, intended for creative-only items such as spawn eggs.", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."})
    List<String> unobtainableItemsRaw = (List)Util.make(new ArrayList(KeyedValueProvider.tagAppender((ResourceKey)Registries.ITEM).add((Object[])new Item[]{Items.BEDROCK, Items.BUDDING_AMETHYST, Items.CHORUS_PLANT, Items.END_PORTAL_FRAME, Items.FARMLAND, Items.FROGSPAWN, Items.INFESTED_STONE, Items.INFESTED_COBBLESTONE, Items.INFESTED_STONE_BRICKS, Items.INFESTED_CHISELED_STONE_BRICKS, Items.INFESTED_CRACKED_STONE_BRICKS, Items.INFESTED_MOSSY_STONE_BRICKS, Items.INFESTED_DEEPSLATE, Items.REINFORCED_DEEPSLATE, Items.SPAWNER, Items.BARRIER, Items.COMMAND_BLOCK, Items.CHAIN_COMMAND_BLOCK, Items.REPEATING_COMMAND_BLOCK, Items.COMMAND_BLOCK_MINECART, Items.PETRIFIED_OAK_SLAB, Items.PLAYER_HEAD, Items.STRUCTURE_BLOCK, Items.STRUCTURE_VOID, Items.TRIAL_SPAWNER, Items.VAULT}).asStringList()), list -> list.add("minecraft:*_spawn_egg"));
    @Config(name="hidden_creative_tabs", description={"Creative mode tabs containing items inaccessible in survival that should be excluded from the item groups, such as the operator items tab. ", "Format for every entry is \"<namespace>:<path>\". Tags are supported, must be in the format of \"#<namespace>:<path>\". Namespace may be omitted to use \"minecraft\" by default. May use asterisk as wildcard parameter via pattern matching, e.g. \"minecraft:*_shulker_box\" to match all shulker boxes no matter of color. Begin an entry with \"!\" to make sure it is excluded, useful e.g. when it has already been matched by another pattern."})
    List<String> hiddenCreativeTabsRaw = KeyedValueProvider.tagAppender((ResourceKey)Registries.CREATIVE_MODE_TAB).addKey(CreativeModeTabs.OP_BLOCKS).asStringList();
    public ConfigDataSet<Item> indexedItems;
    public ConfigDataSet<Item> unobtainableItems;
    public ConfigDataSet<CreativeModeTab> hiddenCreativeTabs;

    public void afterConfigReload() {
        this.indexedItems = ConfigDataSet.from((ResourceKey)Registries.ITEM, this.indexedItemsRaw, (Class[])new Class[0]);
        this.unobtainableItems = ConfigDataSet.from((ResourceKey)Registries.ITEM, this.unobtainableItemsRaw, (Class[])new Class[0]);
        this.hiddenCreativeTabs = ConfigDataSet.from((ResourceKey)Registries.CREATIVE_MODE_TAB, this.hiddenCreativeTabsRaw, (Class[])new Class[0]);
    }

    public boolean filterItems(Item item) {
        if (this.indexedItems.isEmpty() || this.indexedItems.contains((Object)item)) {
            return !this.unobtainableItems.contains((Object)item);
        }
        return false;
    }

    public static enum IndexButtonScreen {
        PAUSE_MENU,
        INVENTORY_MENU,
        BOTH;

    }
}

