/*
 * Decompiled with CFR 0.152.
 */
package com.crawkatt.ttsmod.util;

import com.crawkatt.ttsmod.util.SubtitlePosition;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_757;

public class SubtitleRenderer {
    public static String currentMessage = "";
    public static long endTime = 0L;
    private static boolean typewriterEnabled;
    private static final int charsPerSecond = 5;
    private static SubtitlePosition position;
    private static final Map<String, Integer> COLOR_MAP;
    private static long startTime;

    public static void setSubtitle(String message, long durationMs, SubtitlePosition pos, boolean typewriterEnable) {
        currentMessage = message;
        startTime = System.currentTimeMillis();
        endTime = startTime + durationMs;
        position = pos;
        typewriterEnabled = typewriterEnable;
    }

    public static void renderSubtitlesOverlay(class_332 guiGraphics) {
        if (!currentMessage.isEmpty() && System.currentTimeMillis() < endTime) {
            class_310 minecraft = class_310.method_1551();
            int screenWidth = minecraft.method_22683().method_4486();
            int screenHeight = minecraft.method_22683().method_4502();
            long elapsedTime = System.currentTimeMillis() - startTime;
            int totalCharsToShow = typewriterEnabled ? (int)((double)elapsedTime / 1000.0 * 5.0) : Integer.MAX_VALUE;
            String[] lines = currentMessage.split(";");
            ArrayList<List<TextSegment>> renderedSegmentLines = new ArrayList<List<TextSegment>>();
            for (String string : lines) {
                List<TextSegment> parsed = SubtitleRenderer.parseColoredLine(string.trim());
                List<TextSegment> clipped = SubtitleRenderer.clipSegmentsToLength(parsed, totalCharsToShow);
                renderedSegmentLines.add(clipped);
                int consumed = 0;
                Iterator<TextSegment> iterator = clipped.iterator();
                while (iterator.hasNext()) {
                    TextSegment segment = iterator.next();
                    consumed += segment.text.length();
                }
                if ((totalCharsToShow -= consumed) <= 0) break;
            }
            Objects.requireNonNull(minecraft.field_1772);
            int lineHeight = 9;
            int maxWidth = 0;
            for (List list : renderedSegmentLines) {
                int lineWidth = 0;
                for (TextSegment segment : list) {
                    lineWidth += minecraft.field_1772.method_1727(segment.text);
                }
                if (lineWidth <= maxWidth) continue;
                maxWidth = lineWidth;
            }
            int totalWidth = maxWidth + 10;
            int n = renderedSegmentLines.size() * lineHeight + 10;
            int startX = screenWidth / 2 - totalWidth / 2;
            int startY = switch (position) {
                case SubtitlePosition.TOP -> 30;
                case SubtitlePosition.CENTER -> screenHeight / 2 - n / 2;
                default -> screenHeight - n - 60;
            };
            int endX = startX + totalWidth;
            int endY = startY + n;
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader(class_757::method_34540);
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 1000.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.method_25294(startX, startY, endX, endY, -1728053248);
            for (int i = 0; i < renderedSegmentLines.size(); ++i) {
                List segments = (List)renderedSegmentLines.get(i);
                int totalLineWidth = 0;
                for (TextSegment segment : segments) {
                    totalLineWidth += minecraft.field_1772.method_1727(segment.text);
                }
                int x = screenWidth / 2 - totalLineWidth / 2;
                int y = startY + 5 + i * lineHeight;
                for (TextSegment segment : segments) {
                    guiGraphics.method_51433(minecraft.field_1772, segment.text, x, y, segment.color, false);
                    x += minecraft.field_1772.method_1727(segment.text);
                }
            }
            guiGraphics.method_51448().method_22909();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static List<TextSegment> clipSegmentsToLength(List<TextSegment> segments, int maxChars) {
        ArrayList<TextSegment> result = new ArrayList<TextSegment>();
        int remaining = maxChars;
        for (TextSegment segment : segments) {
            if (remaining <= 0) break;
            String text = segment.text;
            if (text.length() <= remaining) {
                result.add(new TextSegment(text, segment.color));
                remaining -= text.length();
                continue;
            }
            result.add(new TextSegment(text.substring(0, remaining), segment.color));
            break;
        }
        return result;
    }

    private static List<TextSegment> parseColoredLine(String line) {
        ArrayList<TextSegment> segments = new ArrayList<TextSegment>();
        Pattern pattern = Pattern.compile("([a-zA-Z]+)#(.*?)#");
        Matcher matcher = pattern.matcher(line);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                segments.add(new TextSegment(line.substring(lastEnd, matcher.start()), COLOR_MAP.get("white")));
            }
            String colorName = matcher.group(1).toLowerCase();
            String content = matcher.group(2);
            int color = COLOR_MAP.getOrDefault(colorName, COLOR_MAP.get("white"));
            segments.add(new TextSegment(content, color));
            lastEnd = matcher.end();
        }
        if (lastEnd < line.length()) {
            segments.add(new TextSegment(line.substring(lastEnd), COLOR_MAP.get("white")));
        }
        return segments;
    }

    static {
        position = SubtitlePosition.BOTTOM;
        COLOR_MAP = Map.of("red", -43691, "green", -11141291, "blue", -11184641, "yellow", -171, "orange", -25344, "white", -1);
        startTime = 0L;
    }

    private static class TextSegment {
        String text;
        int color;

        TextSegment(String text, int color) {
            this.text = text;
            this.color = color;
        }
    }
}

