import os
import tkinter as tk
from tkinter import filedialog, messagebox

class FileReplacerGUI:
    def __init__(self, root):
        self.root = root
        self.root.title("File Replacer Tool")

        # Labels and entry fields for inputs
        tk.Label(root, text="Word to replace 'all':").grid(row=0, column=0, sticky=tk.W, padx=10, pady=5)
        self.replace_word_entry = tk.Entry(root, width=30)
        self.replace_word_entry.insert(0, "all")  # Default replacement word
        self.replace_word_entry.grid(row=0, column=1, padx=10, pady=5)

        # Select directory button
        self.directory_path = tk.StringVar()
        tk.Button(root, text="Select Directory", command=self.select_directory).grid(row=1, column=0, columnspan=2, pady=10)
        self.dir_label = tk.Label(root, text="No directory selected", fg="gray")
        self.dir_label.grid(row=2, column=0, columnspan=2)

        # Process button
        tk.Button(root, text="Process Files", command=self.process_files).grid(row=3, column=0, columnspan=2, pady=10)

    def select_directory(self):
        directory = filedialog.askdirectory()
        if directory:
            self.directory_path.set(directory)
            self.dir_label.config(text=directory, fg="black")

    def process_files(self):
        directory = self.directory_path.get()
        if not directory:
            messagebox.showerror("Error", "Please select a directory.")
            return

        replace_word = self.replace_word_entry.get().strip()

        if not replace_word:
            messagebox.showerror("Error", "Please enter a replacement word.")
            return

        # Process files in the selected directory
        files = [f for f in os.listdir(directory) if os.path.isfile(os.path.join(directory, f))]

        for file_name in files:
            # Get the full path of the original file
            file_path = os.path.join(directory, file_name)

            # Replace 'all' inside the file but not 'textures'
            try:
                with open(file_path, 'r', encoding='utf-8') as file:
                    content = file.read()

                # Replace 'all' but avoid replacing 'textures'
                content = content.replace('all', replace_word).replace(replace_word + 's', 'textures')

                with open(file_path, 'w', encoding='utf-8') as file:
                    file.write(content)

                print(f"Processed file: {file_path}")
            except UnicodeDecodeError as e:
                print(f"Error reading {file_path}: {e}")

        messagebox.showinfo("Success", "Files processed successfully.")

if __name__ == "__main__":
    root = tk.Tk()
    app = FileReplacerGUI(root)
    root.mainloop()