import os
import tkinter as tk
from tkinter import filedialog, messagebox

class FileReplacerGUI:
    def __init__(self, root):
        self.root = root
        self.root.title("File Replacer Tool")

        # Labels and entry fields for inputs
        tk.Label(root, text="New first word for file names:").grid(row=0, column=0, sticky=tk.W, padx=10, pady=5)
        self.first_word_entry = tk.Entry(root, width=30)
        self.first_word_entry.grid(row=0, column=1, padx=10, pady=5)

        tk.Label(root, text="Word to replace 'black':").grid(row=1, column=0, sticky=tk.W, padx=10, pady=5)
        self.replace_word_entry = tk.Entry(root, width=30)
        self.replace_word_entry.grid(row=1, column=1, padx=10, pady=5)

        # Select directory button
        self.directory_path = tk.StringVar()
        tk.Button(root, text="Select Directory", command=self.select_directory).grid(row=2, column=0, columnspan=2, pady=10)
        self.dir_label = tk.Label(root, text="No directory selected", fg="gray")
        self.dir_label.grid(row=3, column=0, columnspan=2)

        # Process button
        tk.Button(root, text="Process Files", command=self.process_files).grid(row=4, column=0, columnspan=2, pady=10)

    def select_directory(self):
        directory = filedialog.askdirectory()
        if directory:
            self.directory_path.set(directory)
            self.dir_label.config(text=directory, fg="black")

    def process_files(self):
        directory = self.directory_path.get()
        if not directory:
            messagebox.showerror("Error", "Please select a directory.")
            return

        new_first_word = self.first_word_entry.get().strip()
        replace_black_word = self.replace_word_entry.get().strip()

        if not new_first_word or not replace_black_word:
            messagebox.showerror("Error", "Please fill in both input fields.")
            return

        # Process files in the selected directory
        files = [f for f in os.listdir(directory) if os.path.isfile(os.path.join(directory, f)) and '_' in f]

        for file_name in files:
            # Get the full path of the original file
            original_file_path = os.path.join(directory, file_name)

            # Replace the first word in the file name
            parts = file_name.split('_')
            parts[0] = new_first_word
            new_file_name = '_'.join(parts)

            # Get the full path of the new file
            new_file_path = os.path.join(directory, new_file_name)

            # Rename the file
            os.rename(original_file_path, new_file_path)

            # Replace 'black' inside the file
            try:
                with open(new_file_path, 'r', encoding='utf-8') as file:
                    content = file.read()

                content = content.replace('black', replace_black_word)

                with open(new_file_path, 'w', encoding='utf-8') as file:
                    file.write(content)

                print(f"Processed file: {original_file_path} -> {new_file_path}")
            except UnicodeDecodeError as e:
                print(f"Error reading {original_file_path}: {e}")

        messagebox.showinfo("Success", "Files processed successfully.")

if __name__ == "__main__":
    root = tk.Tk()
    app = FileReplacerGUI(root)
    root.mainloop()
