/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.consolefix.bungee;

import java.nio.file.Path;
import link.star_dust.bstats.bungeecord.Metrics;
import link.star_dust.consolefix.bungee.BungeeCommandHandler;
import link.star_dust.consolefix.bungee.ConfigHandler;
import link.star_dust.consolefix.bungee.EngineInterface;
import link.star_dust.consolefix.bungee.NewEngine;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeeCSF
extends Plugin {
    public static final String PLUGIN_NAME = "ConsoleSpamFixReborn";
    private ConfigHandler configHandler;
    private EngineInterface engine;
    private Metrics metrics;

    public void onEnable() {
        this.configHandler = new ConfigHandler(this);
        if (!this.configHandler.loadConfig()) {
            this.getLogger().warning("Failed to load configuration. The plugin may not function correctly.");
        }
        this.engine = new NewEngine(this);
        int pluginId = 25292;
        new Metrics(this, pluginId);
        ProxyServer.getInstance().getPluginManager().registerCommand((Plugin)this, (Command)new BungeeCommandHandler(this.configHandler, this.engine, this));
        this.updateLogFilter();
        this.getLogger().info("ConsoleSpamFixReborn v" + this.getDescription().getVersion() + " loaded successfully!");
    }

    public void updateLogFilter() {
        if (this.engine == null || this.configHandler == null) {
            this.getLogger().warning("Cannot update log filter: Engine or ConfigHandler is not initialized yet!");
            return;
        }
        this.engine.hideConsoleMessages();
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public EngineInterface getEngine() {
        return this.engine;
    }

    public Path getDataDirectory() {
        return this.getDataFolder().toPath();
    }
}

