/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.consolefix.bungee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import link.star_dust.consolefix.bungee.BungeeCSF;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class ConfigHandler {
    private final BungeeCSF plugin;
    private Configuration config;

    public ConfigHandler(BungeeCSF plugin) {
        this.plugin = plugin;
    }

    public boolean loadConfig() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            this.plugin.getLogger().info("No config file found! Copying default config from JAR...");
            this.plugin.getDataFolder().mkdirs();
            try (InputStream in = this.plugin.getResourceAsStream("config-bungee.yml");){
                Files.copy(in, configFile.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to copy default config file!");
                e.printStackTrace();
                return false;
            }
        }
        try {
            this.plugin.getLogger().info("Loading the config file...");
            this.config = ConfigurationProvider.getProvider(YamlConfiguration.class).load(configFile);
            this.plugin.getLogger().info("Config file loaded successfully!");
            return true;
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not load config file!");
            e.printStackTrace();
            return false;
        }
    }

    public List<String> getStringList(String key) {
        if (!this.config.contains(key)) {
            throw new RuntimeException("Missing required key in config.yml: " + key);
        }
        return this.config.getStringList(key);
    }

    public String getString(String key) {
        if (!this.config.contains(key)) {
            throw new RuntimeException("Missing required key in config.yml: " + key);
        }
        return this.config.getString(key);
    }
}

