/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.consolefix.velocity;

import com.velocitypowered.api.plugin.PluginContainer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import link.star_dust.consolefix.velocity.VelocityCSF;
import org.slf4j.Logger;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class ConfigHandler {
    private final Logger logger;
    private final Path dataDirectory;
    private final PluginContainer pluginContainer;
    private CommentedConfigurationNode configNode;
    private ConfigurationLoader<CommentedConfigurationNode> loader;

    public ConfigHandler(VelocityCSF velocityCSF) {
        this.logger = velocityCSF.getLogger();
        this.dataDirectory = velocityCSF.getDataDirectory();
        this.pluginContainer = velocityCSF.getPluginContainer();
    }

    public boolean loadConfig() {
        File pluginFolder = this.dataDirectory.toFile();
        if (!pluginFolder.exists()) {
            pluginFolder.mkdirs();
        }
        File configFile = new File(this.dataDirectory.toFile(), "config.yml");
        this.loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(configFile.toPath())).build();
        if (!configFile.exists()) {
            this.logger.info("No config file found! Copying default config from JAR...");
            this.copyDefaultConfigFromJar(configFile);
        }
        try {
            this.logger.info("Loading the config file...");
            this.configNode = this.loader.load();
            this.logger.info("Config file loaded successfully!");
            return true;
        }
        catch (ConfigurateException e) {
            this.logger.error("Could not load config file! Error: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private void copyDefaultConfigFromJar(File configFile) {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("config-velocity.yml");){
            if (inputStream == null) {
                this.logger.error("Default config file 'config-velocity.yml' is missing from the JAR!");
                return;
            }
            try (FileOutputStream outputStream = new FileOutputStream(configFile);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inputStream.read(buffer)) > 0) {
                    ((OutputStream)outputStream).write(buffer, 0, length);
                }
            }
            this.logger.info("Default config file has been copied successfully.");
        }
        catch (IOException e) {
            this.logger.error("Failed to copy default config file! Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public List<String> getStringList(String key) throws SerializationException {
        if (((CommentedConfigurationNode)this.configNode.node(new Object[]{key})).virtual()) {
            throw new RuntimeException("Missing required key in config.yml: " + key);
        }
        return ((CommentedConfigurationNode)this.configNode.node(new Object[]{key})).getList(String.class);
    }

    public String getString(String key) {
        if (((CommentedConfigurationNode)this.configNode.node(new Object[]{key})).virtual()) {
            throw new RuntimeException("Missing required key in config.yml: " + key);
        }
        return ((CommentedConfigurationNode)this.configNode.node(new Object[]{key})).getString();
    }

    public String getChatMessage(String key) {
        String message = this.getString("ChatMessages." + key);
        if (message == null) {
            throw new RuntimeException("Missing required chat message in config.yml: ChatMessages." + key);
        }
        return message.replaceAll("&", "\u00a7");
    }
}

