/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.consolefix.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import java.nio.file.Path;
import link.star_dust.bstats.velocity.Metrics;
import link.star_dust.consolefix.velocity.ConfigHandler;
import link.star_dust.consolefix.velocity.EngineInterface;
import link.star_dust.consolefix.velocity.LogFilter;
import link.star_dust.consolefix.velocity.LogFilterManager;
import link.star_dust.consolefix.velocity.NewEngine;
import link.star_dust.consolefix.velocity.VelocityCommandHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.slf4j.Logger;
import org.spongepowered.configurate.serialize.SerializationException;

@Plugin(id="consolefixreborn", name="ConsoleSpamFixReborn", version="1.0.0", description="Fixes console spam", authors={"CraftersLand", "Author87668"})
public class VelocityCSF {
    public static final String PLUGIN_NAME = "ConsoleSpamFixReborn";
    private final Logger logger;
    private final ProxyServer server;
    private final Path dataDirectory;
    private final PluginContainer pluginContainer;
    private LogFilter logFilter;
    private final LogFilterManager logFilterManager;
    private ConfigHandler configHandler;
    private EngineInterface engine;
    private Metrics metrics;
    private final Metrics.Factory metricsFactory;

    @Inject
    public VelocityCSF(Logger logger, ProxyServer server, @DataDirectory Path dataDirectory, PluginContainer pluginContainer, Metrics.Factory metricsFactory) {
        this.logger = logger;
        this.server = server;
        this.dataDirectory = dataDirectory;
        this.pluginContainer = pluginContainer;
        this.metricsFactory = metricsFactory;
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = loggerContext.getConfiguration();
        this.logFilterManager = new LogFilterManager(this);
    }

    public void updateLogFilter() {
        if (this.engine == null || this.configHandler == null) {
            this.logger.error("Cannot update log filter: Engine or ConfigHandler is not initialized yet!");
            return;
        }
        this.engine.hideConsoleMessages();
    }

    @Subscribe
    public void onProxyInitialize(ProxyInitializeEvent event) throws SerializationException {
        this.configHandler = new ConfigHandler(this);
        if (!this.configHandler.loadConfig()) {
            this.logger.error("Failed to load configuration. The plugin may not function correctly.");
        }
        this.engine = new NewEngine(this);
        this.engine.hideConsoleMessages();
        int pluginId = 25291;
        this.metricsFactory.make(this, pluginId);
        this.server.getCommandManager().register("csfv", (Command)new VelocityCommandHandler(this.configHandler, this.engine, this, this.logFilter, this.logFilterManager), new String[0]);
        this.updateLogFilter();
        this.logger.info("{} v{} loaded successfully!", (Object)PLUGIN_NAME, (Object)this.pluginContainer.getDescription().getVersion().orElse("Unknown"));
    }

    public ConfigHandler getConfigHandler() {
        return this.configHandler;
    }

    public EngineInterface getEngine() {
        return this.engine;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    public PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }
}

