/*
 * Decompiled with CFR 0.152.
 */
package link.star_dust.consolefix.velocity;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import link.star_dust.consolefix.velocity.ConfigHandler;
import link.star_dust.consolefix.velocity.EngineInterface;
import link.star_dust.consolefix.velocity.LogFilter;
import link.star_dust.consolefix.velocity.LogFilterManager;
import link.star_dust.consolefix.velocity.VelocityCSF;
import net.kyori.adventure.text.Component;
import org.spongepowered.configurate.serialize.SerializationException;

public class VelocityCommandHandler
implements SimpleCommand {
    private final ConfigHandler configHandler;
    private final VelocityCSF velocityCSF;
    private final LogFilter logFilter;
    private final LogFilterManager logFilterManager;

    public VelocityCommandHandler(ConfigHandler configHandler, EngineInterface enginem, VelocityCSF velocityCSF, LogFilter logFilter, LogFilterManager logFilterManager) throws SerializationException {
        this.velocityCSF = velocityCSF;
        this.configHandler = configHandler;
        this.logFilterManager = new LogFilterManager(velocityCSF);
        this.logFilter = new LogFilter(velocityCSF);
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (!this.hasPermission(invocation)) {
            source.sendMessage((Component)Component.text((String)"You don't have permission to do that."));
            return;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            boolean success = this.configHandler.loadConfig();
            if (success) {
                if (this.logFilter != null) {
                    try {
                        this.logFilterManager.updateFilter(this.velocityCSF.getConfigHandler().getStringList("Messages-To-Hide-Filter"));
                    }
                    catch (SerializationException e) {
                        e.printStackTrace();
                    }
                    source.sendMessage((Component)Component.text((String)"Reload successful!"));
                } else {
                    source.sendMessage((Component)Component.text((String)"LogFilter is not initialized. Reload failed."));
                }
            } else {
                source.sendMessage((Component)Component.text((String)"Failed to reload the config. Check the console for errors."));
            }
        } else {
            source.sendMessage((Component)Component.text((String)"Reload Config: /csfv reload"));
        }
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("csf.admin");
    }
}

