/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui.components;

import bre2el.fpsreducer.gui.components.SelectButtons;
import bre2el.fpsreducer.gui.components.UnobtrusiveTooltip;
import java.time.Duration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;

public class TexturedButtonEx
extends ImageButton
implements UnobtrusiveTooltip {
    private final WidgetSprites textures;
    private boolean pressed;
    private SelectButtons selectButtons;

    public TexturedButtonEx(int x, int y, int width, int height, WidgetSprites textures, Button.OnPress pressAction, Component text, boolean pressed) {
        super(x, y, width, height, textures, pressAction, text);
        this.textures = textures;
        this.pressed = pressed;
    }

    public void onPress(InputWithModifiers inputWithModifiers) {
        this.setPressed(true);
        if (this.selectButtons != null) {
            this.selectButtons.resetOthers(this);
        }
        super.onPress(inputWithModifiers);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.textures.get(this.pressed, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)this.alpha));
    }

    protected void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    protected void setSelectButtons(SelectButtons selBtns) {
        this.selectButtons = selBtns;
    }

    public TexturedButtonEx setTooltip(Component tooltip) {
        super.setTooltip(Tooltip.create((Component)tooltip));
        return this;
    }

    public TexturedButtonEx setTooltipWait(Duration delay) {
        super.setTooltipDelay(delay);
        return this;
    }
}

