/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.dimensionspawn.event;

import de.eztxm.dimensionspawn.config.Config;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dimensionspawn", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnEvent {
    @SubscribeEvent
    public static void onPlayerFirstJoin(PlayerEvent.PlayerLoggedInEvent event) {
        int statCounter;
        ServerPlayer player;
        if (event.getEntity() != null && (player = (ServerPlayer)event.getEntity()) != null && (statCounter = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12989_))) == 0) {
            SpawnEvent.handleTeleport((Player)player);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player;
        if (event.getEntity() != null && (player = (ServerPlayer)event.getEntity()) != null && !event.isEndConquered() && player.m_8961_() == null) {
            SpawnEvent.handleTeleport((Player)player);
        }
    }

    private static void handleTeleport(Player player) {
        boolean useDimension = (Boolean)Config.useDimensionEntry.get();
        final boolean useCoordinates = (Boolean)Config.useCoordinatesEntry.get();
        final boolean safeSpawn = (Boolean)Config.safeSpawn.get();
        final int safeSpawnRange = (Integer)Config.safeSpawnRange.get();
        if (useDimension) {
            String[] dimensionSplit = ((String)Config.dimensionEntry.get()).split(":");
            ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(dimensionSplit[0], dimensionSplit[1]));
            Level level = player.m_9236_();
            ServerLevel dimension = Objects.requireNonNull(level.m_7654_()).m_129880_(dimensionKey);
            if (dimension == null) {
                player.m_213846_((Component)Component.m_237113_((String)("[DimensionSpawn] The dimension " + String.valueOf(dimensionKey) + " does not exist in this instance.")));
                return;
            }
            player.changeDimension(dimension, new ITeleporter(){

                public Entity placeEntity(Entity entity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
                    entity = repositionEntity.apply(false);
                    if (useCoordinates) {
                        double x = (Double)Config.xEntry.get();
                        double y = (Double)Config.yEntry.get();
                        double z = (Double)Config.zEntry.get();
                        float cYaw = ((Double)Config.yawEntry.get()).floatValue();
                        float cPitch = ((Double)Config.pitchEntry.get()).floatValue();
                        if (safeSpawn) {
                            BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
                            BlockPos safeBlockPos = SpawnEvent.validPlayerSpawnLocation(destWorld, blockPos, safeSpawnRange);
                            if (safeBlockPos == null) {
                                entity.m_264318_(destWorld, x, y, z, Collections.emptySet(), cYaw, cPitch);
                                return entity;
                            }
                            entity.m_264318_(destWorld, (double)safeBlockPos.m_123341_(), (double)safeBlockPos.m_123342_(), (double)safeBlockPos.m_123343_(), Collections.emptySet(), cYaw, cPitch);
                            return entity;
                        }
                        entity.m_264318_(destWorld, x, y, z, Collections.emptySet(), cYaw, cPitch);
                    }
                    return entity;
                }

                public boolean playTeleportSound(ServerPlayer player, ServerLevel sourceWorld, ServerLevel destWorld) {
                    return false;
                }
            });
            return;
        }
        if (useCoordinates) {
            double x = (Double)Config.xEntry.get();
            double y = (Double)Config.yEntry.get();
            double z = (Double)Config.zEntry.get();
            float cYaw = ((Double)Config.yawEntry.get()).floatValue();
            float cPitch = ((Double)Config.pitchEntry.get()).floatValue();
            player.m_264318_((ServerLevel)player.m_9236_(), x, y, z, Collections.emptySet(), cYaw, cPitch);
        }
    }

    public static BlockPos validPlayerSpawnLocation(ServerLevel world, BlockPos position, int maximumRange) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        for (int range = 0; range < maximumRange; ++range) {
            int radiusSq = range * range;
            int outerRadiusSq = (range + 1) * (range + 1);
            for (int yOffset = -range; yOffset <= range; ++yOffset) {
                for (int xOffset = -range; xOffset <= range; ++xOffset) {
                    for (int zOffset = -range; zOffset <= range; ++zOffset) {
                        int distanceSq = xOffset * xOffset + yOffset * yOffset + zOffset * zOffset;
                        if (distanceSq < radiusSq || distanceSq >= outerRadiusSq) continue;
                        currentPos.m_122178_(position.m_123341_() + xOffset, position.m_123342_() + yOffset, position.m_123343_() + zOffset);
                        if (!world.m_8055_(currentPos.m_7495_()).m_60815_() || !world.m_8055_((BlockPos)currentPos).m_60795_() || !world.m_8055_(currentPos.m_7494_()).m_60795_()) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }
}

