/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.dimensionspawn.config;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final String CONFIG_FILE = "dimensionspawn.properties";
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("dimensionspawn.properties");
    public boolean safeSpawn = false;
    public int safeSpawnRange = 100;
    public boolean useDimensionEntry = false;
    public String dimensionEntry = "minecraft:overworld";
    public boolean useCoordinatesEntry = false;
    public double xEntry = 0.0;
    public double yEntry = 0.0;
    public double zEntry = 0.0;
    public float yawEntry = 0.0f;
    public float pitchEntry = 0.0f;
    private static Config INSTANCE;

    public static Config get() {
        if (INSTANCE == null) {
            INSTANCE = new Config();
            INSTANCE.load();
        }
        return INSTANCE;
    }

    public void load() {
        Properties props = new Properties();
        if (CONFIG_PATH.toFile().exists()) {
            try (FileInputStream in = new FileInputStream(CONFIG_PATH.toFile());){
                props.load(in);
                this.safeSpawn = Boolean.parseBoolean(props.getProperty("safeSpawn", "false"));
                this.safeSpawnRange = Integer.parseInt(props.getProperty("safeSpawnRange", "100"));
                this.useDimensionEntry = Boolean.parseBoolean(props.getProperty("useDimensionEntry", "false"));
                this.dimensionEntry = props.getProperty("dimensionEntry", "minecraft:overworld");
                this.useCoordinatesEntry = Boolean.parseBoolean(props.getProperty("useCoordinatesEntry", "false"));
                this.xEntry = Double.parseDouble(props.getProperty("xEntry", "0.0"));
                this.yEntry = Double.parseDouble(props.getProperty("yEntry", "0.0"));
                this.zEntry = Double.parseDouble(props.getProperty("zEntry", "0.0"));
                this.yawEntry = Float.parseFloat(props.getProperty("yawEntry", "0.0"));
                this.pitchEntry = Float.parseFloat(props.getProperty("pitchEntry", "0.0"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.save();
        }
    }

    public void save() {
        Properties props = new Properties();
        props.setProperty("safeSpawn", Boolean.toString(this.safeSpawn));
        props.setProperty("safeSpawnRange", Integer.toString(this.safeSpawnRange));
        props.setProperty("useDimensionEntry", Boolean.toString(this.useDimensionEntry));
        props.setProperty("dimensionEntry", this.dimensionEntry);
        props.setProperty("useCoordinatesEntry", Boolean.toString(this.useCoordinatesEntry));
        props.setProperty("xEntry", Double.toString(this.xEntry));
        props.setProperty("yEntry", Double.toString(this.yEntry));
        props.setProperty("zEntry", Double.toString(this.zEntry));
        props.setProperty("yawEntry", Double.toString(this.yawEntry));
        props.setProperty("pitchEntry", Double.toString(this.pitchEntry));
        try (FileOutputStream out = new FileOutputStream(CONFIG_PATH.toFile());){
            props.store(out, "DimensionSpawn Config");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

