/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.dimensionspawn.mixin;

import de.eztxm.dimensionspawn.config.Config;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_3468;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3324.class})
public class PlayerEventMixin {
    @Inject(at={@At(value="TAIL")}, method={"onPlayerConnect"})
    private void onPlayerJoin(class_2535 connection, class_3222 player, CallbackInfo ci) {
        if (player.method_14248().method_15025(class_3468.field_15419.method_14956((Object)class_3468.field_15389)) < 1) {
            if (Config.get().useDimensionEntry) {
                String[] dimensionSplit = Config.get().dimensionEntry.split(":");
                class_5321 dimensionKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(dimensionSplit[0], dimensionSplit[1]));
                class_1937 world = player.method_37908();
                class_3218 dimension = Objects.requireNonNull(world.method_8503()).method_3847(dimensionKey);
                if (dimension == null) {
                    player.method_43496(class_2561.method_30163((String)("[DimensionSpawn] The dimension " + String.valueOf(dimensionKey) + " does not exist in this instance.")));
                    return;
                }
                if (Config.get().safeSpawn) {
                    if (Config.get().useCoordinatesEntry) {
                        class_2338 blockPos = new class_2338((int)Config.get().xEntry, (int)Config.get().yEntry, (int)Config.get().zEntry);
                        class_2338 safeBlockPos = this.validPlayerSpawnLocation(dimension, blockPos, Config.get().safeSpawnRange);
                        if (safeBlockPos != null) {
                            player.method_14251(dimension, (double)safeBlockPos.method_10263(), (double)safeBlockPos.method_10264(), (double)safeBlockPos.method_10260(), Config.get().yawEntry, Config.get().pitchEntry);
                            return;
                        }
                        return;
                    }
                    class_2338 safeBlockPos = this.validPlayerSpawnLocation(dimension, dimension.method_43126(), Config.get().safeSpawnRange);
                    if (safeBlockPos != null) {
                        player.method_14251(dimension, (double)safeBlockPos.method_10263(), (double)safeBlockPos.method_10264(), (double)safeBlockPos.method_10260(), 0.0f, 0.0f);
                        return;
                    }
                }
                if (Config.get().useCoordinatesEntry) {
                    player.method_14251(dimension, Config.get().xEntry, Config.get().yEntry, Config.get().zEntry, Config.get().yawEntry, Config.get().pitchEntry);
                    return;
                }
                player.method_14251(dimension, (double)dimension.method_43126().method_10263(), (double)dimension.method_43126().method_10264(), (double)dimension.method_43126().method_10260(), 0.0f, 0.0f);
                return;
            }
            if (Config.get().useCoordinatesEntry) {
                player.method_14251(player.method_51469(), Config.get().xEntry, Config.get().yEntry, Config.get().zEntry, Config.get().yawEntry, Config.get().pitchEntry);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"respawnPlayer"})
    private void respawnPlayer(class_3222 player, boolean alive, CallbackInfoReturnable<class_3222> cir) {
        if (Objects.equals(player.method_51469().method_27983().method_41185(), new class_2960("minecraft", "the_end"))) {
            class_3218 overworld = Objects.requireNonNull(player.method_5682()).method_30002();
            player.method_26284(overworld.method_27983(), overworld.method_43126(), 0.0f, true, false);
            return;
        }
        if (Config.get().useDimensionEntry) {
            String[] dimensionSplit = Config.get().dimensionEntry.split(":");
            class_5321 dimensionKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(dimensionSplit[0], dimensionSplit[1]));
            if (Config.get().useCoordinatesEntry) {
                class_2338 blockPos = new class_2338((int)Config.get().xEntry, (int)Config.get().yEntry, (int)Config.get().zEntry);
                if (Config.get().safeSpawn) {
                    class_2338 safeBlockPos = this.validPlayerSpawnLocation(Objects.requireNonNull(player.method_5682()).method_3847(dimensionKey), blockPos, Config.get().safeSpawnRange);
                    if (safeBlockPos == null) {
                        return;
                    }
                    player.method_26284(dimensionKey, safeBlockPos, 0.0f, true, false);
                    return;
                }
                player.method_26284(dimensionKey, blockPos, 0.0f, true, false);
            }
            return;
        }
        if (Config.get().useCoordinatesEntry) {
            class_1937 world = player.method_37908();
            class_2338 blockPos = new class_2338((int)Config.get().xEntry, (int)Config.get().yEntry, (int)Config.get().zEntry);
            player.method_26284(world.method_27983(), blockPos, 0.0f, true, false);
        }
    }

    @Unique
    private class_2338 validPlayerSpawnLocation(class_3218 world, class_2338 position, int maximumRange) {
        class_2338.class_2339 currentPos = new class_2338.class_2339();
        for (int range = 0; range < maximumRange; ++range) {
            int radiusSq = range * range;
            int outerRadiusSq = (range + 1) * (range + 1);
            for (int yOffset = -range; yOffset <= range; ++yOffset) {
                for (int xOffset = -range; xOffset <= range; ++xOffset) {
                    for (int zOffset = -range; zOffset <= range; ++zOffset) {
                        int distanceSq = xOffset * xOffset + yOffset * yOffset + zOffset * zOffset;
                        if (distanceSq < radiusSq || distanceSq >= outerRadiusSq) continue;
                        currentPos.method_10103(position.method_10263() + xOffset, position.method_10264() + yOffset, position.method_10260() + zOffset);
                        if (!world.method_8320(currentPos.method_10074()).method_26225() || !world.method_8320((class_2338)currentPos).method_26215() || !world.method_8320(currentPos.method_10084()).method_26215()) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }
}

