/*
 * Decompiled with CFR 0.152.
 */
package de.eztxm.dimensionspawn.event;

import de.eztxm.dimensionspawn.config.Config;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class SpawnEvent {
    @SubscribeEvent
    public void onPlayerFirstJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        int statCounter = player.getStats().getValue(Stats.CUSTOM.get((Object)Stats.LEAVE_GAME));
        if (statCounter == 0) {
            this.handleTeleport((Player)player);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (!event.isEndConquered() && player.getRespawnPosition() == null) {
            this.handleTeleport((Player)player);
        }
    }

    private void handleTeleport(Player player) {
        boolean useDimension = (Boolean)Config.useDimensionEntry.get();
        boolean useCoordinates = (Boolean)Config.useCoordinatesEntry.get();
        if (useDimension) {
            String[] dimensionSplit = ((String)Config.dimensionEntry.get()).split(":");
            ResourceKey dimensionKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)dimensionSplit[0], (String)dimensionSplit[1]));
            Level level = player.level();
            ServerLevel dimension = Objects.requireNonNull(level.getServer()).getLevel(dimensionKey);
            if (dimension == null) {
                ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)("[DimensionSpawn] The dimension " + String.valueOf(dimensionKey) + " does not exist in this instance.")));
                return;
            }
            boolean teleported = this.teleportToDimension((ServerPlayer)player, dimension);
            if (!teleported) {
                ((ServerPlayer)player).sendSystemMessage((Component)Component.literal((String)"[DimensionSpawn] Failed to teleport to the dimension."));
            }
            return;
        }
        if (useCoordinates) {
            double x = (Double)Config.xEntry.get();
            double y = (Double)Config.yEntry.get();
            double z = (Double)Config.zEntry.get();
            float cYaw = ((Double)Config.yawEntry.get()).floatValue();
            float cPitch = ((Double)Config.pitchEntry.get()).floatValue();
            player.teleportTo((ServerLevel)player.level(), x, y, z, Collections.emptySet(), cYaw, cPitch, false);
        }
    }

    private boolean teleportToDimension(ServerPlayer player, ServerLevel destWorld) {
        BlockPos blockPos;
        BlockPos safeBlockPos;
        boolean useCoordinates = (Boolean)Config.useCoordinatesEntry.get();
        boolean safeSpawn = (Boolean)Config.safeSpawn.get();
        int safeSpawnRange = (Integer)Config.safeSpawnRange.get();
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        float cYaw = player.getYRot();
        float cPitch = player.getXRot();
        if (useCoordinates) {
            x = (Double)Config.xEntry.get();
            y = (Double)Config.yEntry.get();
            z = (Double)Config.zEntry.get();
            cYaw = ((Double)Config.yawEntry.get()).floatValue();
            cPitch = ((Double)Config.pitchEntry.get()).floatValue();
        }
        if (safeSpawn && (safeBlockPos = this.validPlayerSpawnLocation(destWorld, blockPos = new BlockPos((int)x, (int)y, (int)z), safeSpawnRange)) != null) {
            x = safeBlockPos.getX();
            y = safeBlockPos.getY();
            z = safeBlockPos.getZ();
        }
        player.teleportTo(destWorld, x, y, z, Collections.emptySet(), cYaw, cPitch, false);
        return true;
    }

    private BlockPos validPlayerSpawnLocation(ServerLevel world, BlockPos position, int maximumRange) {
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        for (int range = 0; range < maximumRange; ++range) {
            int radiusSq = range * range;
            int outerRadiusSq = (range + 1) * (range + 1);
            for (int yOffset = -range; yOffset <= range; ++yOffset) {
                for (int xOffset = -range; xOffset <= range; ++xOffset) {
                    for (int zOffset = -range; zOffset <= range; ++zOffset) {
                        int distanceSq = xOffset * xOffset + yOffset * yOffset + zOffset * zOffset;
                        if (distanceSq < radiusSq || distanceSq >= outerRadiusSq) continue;
                        currentPos.set(position.getX() + xOffset, position.getY() + yOffset, position.getZ() + zOffset);
                        if (!world.getBlockState(currentPos.below()).canOcclude() || !world.getBlockState((BlockPos)currentPos).isAir() || !world.getBlockState(currentPos.above()).isAir()) continue;
                        return currentPos;
                    }
                }
            }
        }
        return null;
    }
}

