/*
 * Decompiled with CFR 0.152.
 */
package com.storyanvil.cogwheel;

import com.storyanvil.cogwheel.CogwheelExecutor;
import com.storyanvil.cogwheel.api.Api;
import com.storyanvil.cogwheel.config.CogwheelClientConfig;
import com.storyanvil.cogwheel.data.SyncArray;
import com.storyanvil.cogwheel.entity.NPCRenderer;
import com.storyanvil.cogwheel.infrastructure.cog.PropertyHandler;
import com.storyanvil.cogwheel.infrastructure.cog.early.CogEarlyRegistry;
import com.storyanvil.cogwheel.infrastructure.env.RegistryEnvironment;
import com.storyanvil.cogwheel.infrastructure.script.DispatchedScript;
import com.storyanvil.cogwheel.network.devui.DevNetwork;
import com.storyanvil.cogwheel.network.mc.CogwheelPacketHandler;
import com.storyanvil.cogwheel.registry.CogwheelBlocks;
import com.storyanvil.cogwheel.registry.CogwheelEntities;
import com.storyanvil.cogwheel.registry.CogwheelItems;
import com.storyanvil.cogwheel.registry.CogwheelRegistries;
import com.storyanvil.cogwheel.registry.CogwheelSounds;
import com.storyanvil.cogwheel.registry.CogwheelUI;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.progress.ProgressMeter;
import net.minecraftforge.fml.loading.progress.StartupNotificationManager;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="storyanvil_cogwheel")
public class CogwheelEngine {
    @Api.Internal
    @ApiStatus.Internal
    public static final String MODID = "storyanvil_cogwheel";
    @Api.Internal
    @ApiStatus.Internal
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL");
    public static final Logger EARLY = LoggerFactory.getLogger((String)"STORYANVIL/COGWHEEL/EARLY-LOGGER");
    public static HashMap<String, PropertyHandler> EARLY_MANAGER = new HashMap();

    public CogwheelEngine(FMLJavaModLoadingContext context) throws InterruptedException {
        ProgressMeter meter = StartupNotificationManager.addProgressBar((String)"COGWHEEL ENGINE - Initializing", (int)3);
        EARLY.info("Initializing");
        CogwheelClientConfig.reload();
        CogwheelExecutor.init();
        IEventBus modEventBus = context.getModEventBus();
        CogwheelBlocks.getBLOCKS().register(modEventBus);
        CogwheelItems.getITEMS().register(modEventBus);
        CogwheelSounds.getSoundEvents().register(modEventBus);
        CogwheelEntities.ENTITY_TYPES.register(modEventBus);
        CogwheelUI.MENU.register(modEventBus);
        CogwheelPacketHandler.init();
        DevNetwork.init();
        CogwheelRegistries.registerDefaultObjects();
        meter.label("COGWHEEL ENGINE - Early Scripts");
        EARLY.info("Loading early scripts");
        meter.increment();
        SyncArray<CogEarlyRegistry> registries = new SyncArray<CogEarlyRegistry>();
        RegistryEnvironment environment = new RegistryEnvironment(registries);
        File scripts = new File(Minecraft.m_91087_().f_91069_, "config/cog/early");
        File[] candidates = scripts.listFiles();
        if (candidates != null) {
            final ProgressMeter meter2 = StartupNotificationManager.addProgressBar((String)"COGWHEEL ENGINE - Early Script Dispatch", (int)candidates.length);
            final CountDownLatch latch = new CountDownLatch(candidates.length);
            for (File candidate : candidates) {
                final String sss = candidate.toString();
                String ssss = candidate.getName();
                StartupNotificationManager.addModMessage((String)("COGWHEEL ENGINE - Dispatching " + String.valueOf(candidate)));
                EARLY.info("Dispatching {}", (Object)candidate);
                try (FileReader fr = new FileReader(candidate);
                     Scanner sc = new Scanner(fr);){
                    ArrayList<String> lines = new ArrayList<String>();
                    while (sc.hasNextLine()) {
                        lines.add(sc.nextLine().trim());
                    }
                    CogwheelExecutor.schedule(new DispatchedScript(lines, environment){

                        @Override
                        public void onEnd() {
                            super.onEnd();
                            StartupNotificationManager.addModMessage((String)("COGWHEEL ENGINE - Dispatched " + sss));
                            EARLY.info("Finished execution {}", (Object)sss);
                            latch.countDown();
                            meter2.increment();
                        }
                    }.setScriptName("early-" + ssss)::lineDispatcher);
                }
                catch (IOException e) {
                    StartupNotificationManager.addModMessage((String)("COGWHEEL ENGINE - FAILED Dispatching " + String.valueOf(candidate)));
                    EARLY.error("Script dispatch failed while file reading", (Throwable)e);
                }
            }
            latch.await();
            meter2.complete();
            StartupNotificationManager.addModMessage((String)"COGWHEEL ENGINE - Scripts executed");
        } else {
            StartupNotificationManager.addModMessage((String)"COGWHEEL ENGINE - No early scripts found");
        }
        StartupNotificationManager.addModMessage((String)"COGWHEEL ENGINE - Disposed early env");
        meter.increment();
        meter.label("COGWHEEL ENGINE - Finishing registry");
        EARLY.info("Finishing registries");
        registries.freeze();
        for (CogEarlyRegistry registry : registries) {
            registry.register(modEventBus);
        }
        registries.dispose();
        environment.dispose();
        EARLY.info("Disposing property managers");
        EARLY_MANAGER.clear();
        EARLY_MANAGER = null;
        meter.complete();
        StartupNotificationManager.addModMessage((String)"COGWHEEL ENGINE - Finished");
    }

    @Mod.EventBusSubscriber(modid="storyanvil_cogwheel", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        @Api.Internal
        @ApiStatus.Internal
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.m_174036_((EntityType)((EntityType)CogwheelEntities.NPC.get()), NPCRenderer::new);
            CogwheelClientConfig.reload();
        }
    }
}

